/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u000553Aa\u0002\u0005\u0001'!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!A\u0004A!A!\u0002\u0013I\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002$\u0001\t\u00039\u0005\"\u0002%\u0001\t\u00039%aF!iG^\u001b6\t\\5f]R\u001cuN\u001c4jOB\u000b'o]3s\u0015\tI!\"A\u0002bQ\u000eT!a\u0003\u0007\u0002\u0005]\u001c(BA\u0007\u000f\u0003\u0011a\u0017NY:\u000b\u0005=\u0001\u0012aA1qS*\t\u0011#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001Qa\u0002CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0011a\u0017M\\4\u000b\u0003e\tAA[1wC&\u00111D\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007u\u0011C%D\u0001\u001f\u0015\ty\u0002%\u0001\u0004j]*,7\r\u001e\u0006\u0002C\u00059!.Y6beR\f\u0017BA\u0012\u001f\u0005!\u0001&o\u001c<jI\u0016\u0014\bCA\u0013'\u001b\u0005A\u0011BA\u0014\t\u0005E\t\u0005nY,T\u00072LWM\u001c;D_:4\u0017nZ\u0001\u000foN\u001cE.[3oi\u000e{gNZ5h!\tQ3&D\u0001\u000b\u0013\ta#B\u0001\bX'\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tyc'D\u00011\u0015\t\t$'\u0001\u0004d_:4\u0017n\u001a\u0006\u0003gQ\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002k\u0005\u00191m\\7\n\u0005]\u0002$AB\"p]\u001aLw-A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014\bCA\u000b;\u0013\tYdCA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005CA\u0013\u0001\u0011\u0015AC\u00011\u0001*\u0011\u0015iC\u00011\u0001/\u0011\u0015AD\u00011\u0001:Q\t!1\t\u0005\u0002\u001e\t&\u0011QI\b\u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G\u000fF\u0001%\u0003\u0015\u0001\u0018M]:fQ\t\u0001!\n\u0005\u0002\u001e\u0017&\u0011AJ\b\u0002\n'&tw\r\\3u_:\u0004")
public class AhcWSClientConfigParser
implements Provider<AhcWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Config configuration;

    public AhcWSClientConfig get() {
        return this.parse();
    }

    public AhcWSClientConfig parse() {
        int maximumConnectionsPerHost = this.configuration.getInt("play.ws.ahc.maxConnectionsPerHost");
        int maximumConnectionsTotal = this.configuration.getInt("play.ws.ahc.maxConnectionsTotal");
        Duration maxConnectionLifetime = this.getDuration$1("play.ws.ahc.maxConnectionLifetime", (Duration)Duration$.MODULE$.Inf());
        Duration idleConnectionInPoolTimeout = this.getDuration$1("play.ws.ahc.idleConnectionInPoolTimeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute());
        Duration connectionPoolCleanerPeriod = this.getDuration$1("play.ws.ahc.connectionPoolCleanerPeriod", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        int maximumNumberOfRedirects = this.configuration.getInt("play.ws.ahc.maxNumberOfRedirects");
        int maxRequestRetry = this.configuration.getInt("play.ws.ahc.maxRequestRetry");
        boolean disableUrlEncoding = this.configuration.getBoolean("play.ws.ahc.disableUrlEncoding");
        boolean keepAlive = this.configuration.getBoolean("play.ws.ahc.keepAlive");
        boolean useLaxCookieEncoder = this.configuration.getBoolean("play.ws.ahc.useLaxCookieEncoder");
        boolean useCookieStore = this.configuration.getBoolean("play.ws.ahc.useCookieStore");
        return new AhcWSClientConfig(this.wsClientConfig, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, connectionPoolCleanerPeriod, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding, keepAlive, useLaxCookieEncoder, useCookieStore);
    }

    private final Duration getDuration$1(String key, Duration duration) {
        Duration duration2;
        try {
            duration2 = Duration$.MODULE$.apply(this.configuration.getString(key));
        }
        catch (ConfigException.Null e) {
            duration2 = duration;
        }
        return duration2;
    }

    @Inject
    public AhcWSClientConfigParser(WSClientConfig wsClientConfig, Config configuration, ClassLoader classLoader) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }
}

