/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirective;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheDirectives$;
import org.playframework.cachecontrol.CacheDirectives$MustRevalidate$;
import org.playframework.cachecontrol.CacheDirectives$ProxyRevalidate$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.FreshnessCalculator;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServeActions;
import org.playframework.cachecontrol.ResponseServeActions$Validate$;
import org.playframework.cachecontrol.ResponseServingCalculator$;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\n\u0015\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0011\u0019\u0001\u0004\u0001)A\u0005[!)\u0011\u0007\u0001C\u0001e!)Q\t\u0001C\t\r\")1\u000b\u0001C\t)\")!\f\u0001C\t7\")\u0001\r\u0001C\tC\")A\u000f\u0001C\tk\")a\u0010\u0001C\t\u007f\"9\u0011\u0011\u0003\u0001\u0005\u0012\u0005M\u0001bBA\u0011\u0001\u0011E\u00111E\u0004\b\u0003k!\u0002\u0012AA\u001c\r\u0019\u0019B\u0003#\u0001\u0002:!1qe\u0004C\u0001\u0003wA\u0011\"!\u0010\u0010\u0005\u0004%I!a\u0010\t\u0011\u00055s\u0002)A\u0005\u0003\u0003\u0012\u0011DU3ta>t7/Z*feZLgnZ\"bY\u000e,H.\u0019;pe*\u0011QCF\u0001\rG\u0006\u001c\u0007.Z2p]R\u0014x\u000e\u001c\u0006\u0003/a\tQ\u0002\u001d7bs\u001a\u0014\u0018-\\3x_J\\'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-A\u0003dC\u000eDW\r\u0005\u0002%K5\tA#\u0003\u0002')\t)1)Y2iK\u00061A(\u001b8jiz\"\"!\u000b\u0016\u0011\u0005\u0011\u0002\u0001\"\u0002\u0012\u0003\u0001\u0004\u0019\u0013a\u00054sKNDg.Z:t\u0007\u0006d7-\u001e7bi>\u0014X#A\u0017\u0011\u0005\u0011r\u0013BA\u0018\u0015\u0005M1%/Z:i]\u0016\u001c8oQ1mGVd\u0017\r^8s\u0003Q1'/Z:i]\u0016\u001c8oQ1mGVd\u0017\r^8sA\u0005i1/\u001a:wKJ+7\u000f]8og\u0016$Ba\r\u001c<\u0001B\u0011A\u0005N\u0005\u0003kQ\u00111CU3ta>t7/Z*feZ,\u0017i\u0019;j_:DQaN\u0003A\u0002a\nqA]3rk\u0016\u001cH\u000f\u0005\u0002%s%\u0011!\b\u0006\u0002\r\u0007\u0006\u001c\u0007.\u001a*fcV,7\u000f\u001e\u0005\u0006y\u0015\u0001\r!P\u0001\te\u0016\u001c\bo\u001c8tKB\u0011AEP\u0005\u0003\u007fQ\u0011ab\u0015;pe\u0016$'+Z:q_:\u001cX\rC\u0003B\u000b\u0001\u0007!)\u0001\u0006dkJ\u0014XM\u001c;BO\u0016\u0004\"\u0001J\"\n\u0005\u0011#\"aB*fG>tGm]\u0001\u0012C2dwn^*uC2,\u0017JZ#se>\u0014HCA$R)\rAu\n\u0015\t\u0003\u00132s!\u0001\n&\n\u0005-#\u0012\u0001\u0006*fgB|gn]3TKJ4X-Q2uS>t7/\u0003\u0002N\u001d\nAa+\u00197jI\u0006$XM\u0003\u0002L)!)qG\u0002a\u0002q!)AH\u0002a\u0002{!)!K\u0002a\u0001\u0005\u0006\u0019\u0011mZ3\u0002\u00199|7)Y2iK\u001a{WO\u001c3\u0015\u0007UC\u0016\fE\u0002\u001e-\"K!a\u0016\u0010\u0003\r=\u0003H/[8o\u0011\u00159t\u0001q\u00019\u0011\u0015at\u0001q\u0001>\u0003U\u0019wN\u001c;bS:\u001c\bK]1h[\u0006tunQ1dQ\u0016$\"\u0001X0\u0011\u0005ui\u0016B\u00010\u001f\u0005\u001d\u0011un\u001c7fC:DQa\u000e\u0005A\u0004a\nA\u0002[3bI\u0016\u00148OR8v]\u0012$2\u0001\u00182t\u0011\u0015\u0019\u0017\u00021\u0001e\u00039qwnQ1dQ\u0016DU-\u00193feN\u00042!Z7q\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002j5\u00051AH]8pizJ\u0011aH\u0005\u0003Yz\tq\u0001]1dW\u0006<W-\u0003\u0002o_\n\u00191+Z9\u000b\u00051t\u0002C\u0001\u0013r\u0013\t\u0011HC\u0001\u0006IK\u0006$WM\u001d(b[\u0016DQ\u0001P\u0005A\u0002u\nQ#[:DC\u000eDW\r\u001a*fgB|gn]3Ge\u0016\u001c\b\u000e\u0006\u0002w{R\u0019qo\u001f?\u0011\u0007u1\u0006\u0010\u0005\u0002Js&\u0011!P\u0014\u0002\u000b'\u0016\u0014h/\u001a$sKND\u0007\"B\u001c\u000b\u0001\bA\u0004\"\u0002\u001f\u000b\u0001\bi\u0004\"B!\u000b\u0001\u0004\u0011\u0015AF5t'R\fG.\u001a*fgB|gn]3BY2|w/\u001a3\u0015\t\u0005\u0005\u0011q\u0002\u000b\u0007\u0003\u0007\tY!!\u0004\u0011\tu1\u0016Q\u0001\t\u0004\u0013\u0006\u001d\u0011bAA\u0005\u001d\nQ1+\u001a:wKN#\u0018\r\\3\t\u000b]Z\u00019\u0001\u001d\t\u000bqZ\u00019A\u001f\t\u000b\u0005[\u0001\u0019\u0001\"\u0002G%\u001c8\u000b^1mKJ+7\u000f]8og\u0016,\u0005\u0010\u001d7jG&$H.\u001f)s_\"L'-\u001b;fIR1\u0011QCA\u000f\u0003?\u0001B!\b,\u0002\u0018A\u0019\u0011*!\u0007\n\u0007\u0005maJA\tWC2LG-\u0019;f\u001fJ$\u0016.\\3pkRDQa\u000e\u0007A\u0004aBQ\u0001\u0010\u0007A\u0004u\n!dY1o'\u0016\u0014h/Z*uC2,\u0017I\u001c3SKZ\fG.\u001b3bi\u0016$B!!\n\u00024Q1\u0011qEA\u0018\u0003c\u0001B!\b,\u0002*A\u0019\u0011*a\u000b\n\u0007\u00055bJA\u000bTKJ4Xm\u0015;bY\u0016\fe\u000e\u001a,bY&$\u0017\r^3\t\u000b]j\u00019\u0001\u001d\t\u000bqj\u00019A\u001f\t\u000bIk\u0001\u0019\u0001\"\u00023I+7\u000f]8og\u0016\u001cVM\u001d<j]\u001e\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003I=\u0019\"a\u0004\u000f\u0015\u0005\u0005]\u0012A\u00027pO\u001e,'/\u0006\u0002\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002Ha\tQa\u001d7gi)LA!a\u0013\u0002F\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b\u0005")
public class ResponseServingCalculator {
    private final Cache cache;
    private final FreshnessCalculator freshnessCalculator;

    private FreshnessCalculator freshnessCalculator() {
        return this.freshnessCalculator;
    }

    public ResponseServeAction serveResponse(CacheRequest request, StoredResponse response, Seconds currentAge) {
        ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("serveResponse: response found for '" + request.method() + " " + request.uri() + "', age = " + currentAge.seconds());
        CacheRequest req = request;
        StoredResponse res = response;
        Option<ResponseServeActions.Validate> explicitValidate = this.noCacheFound(req, res);
        return (ResponseServeAction)explicitValidate.orElse((Function0 & Serializable)() -> {
            Option<ResponseServeActions.ServeFresh> serveFresh = this.isCachedResponseFresh(currentAge, req, res);
            return serveFresh;
        }).orElse((Function0 & Serializable)() -> {
            Option<ResponseServeActions.ValidateOrTimeout> notAllowedStale = this.isStaleResponseExplicitlyProhibited(req, res);
            return notAllowedStale;
        }).orElse((Function0 & Serializable)() -> {
            Option<ResponseServeActions.ServeStale> serveStale = this.isStaleResponseAllowed(currentAge, req, res);
            return serveStale;
        }).orElse((Function0 & Serializable)() -> {
            Option<ResponseServeActions.ServeStaleAndValidate> serveStaleAndRevalidate = this.canServeStaleAndRevalidate(currentAge, req, res);
            return serveStaleAndRevalidate;
        }).getOrElse((Function0 & Serializable)() -> {
            ResponseServeActions.Validate defaultValidation = this.allowStaleIfError(currentAge, req, res);
            return defaultValidation;
        });
    }

    public ResponseServeActions.Validate allowStaleIfError(Seconds age, CacheRequest request, StoredResponse response) {
        ResponseServeActions.Validate v = new ResponseServeActions.Validate("Response is stale, and stale response is not allowed", ResponseServeActions$Validate$.MODULE$.apply$default$2());
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        return (ResponseServeActions.Validate)CacheDirectives$.MODULE$.staleIfError(response.directives()).map((Function1 & Serializable)staleIfError2 -> {
            Seconds delta = staleIfError2.delta();
            boolean serveStale = age.isLessThan(freshnessLifetime.plus(delta));
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("allowStaleIfError: delta = " + delta + ", staleIfError = " + serveStale);
            boolean x$1 = serveStale;
            String x$2 = v.copy$default$1();
            return v.copy(x$2, x$1);
        }).getOrElse((Function0 & Serializable)() -> v);
    }

    public Option<ResponseServeActions.Validate> noCacheFound(CacheRequest request, StoredResponse response) {
        None$ none$;
        if (ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("noCacheFound: request = " + request + ", response = " + response);
        }
        if (request.directives().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResponseServingCalculator.$anonfun$noCacheFound$1(x$1)))) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("noCacheFound: no-cache directive found!");
            String msg = "Request contains no-cache directive, validation required";
            none$ = new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
        } else if (request.directives().isEmpty()) {
            if (this.containsPragmaNoCache(request)) {
                String msg = "Request does not contain Cache-Control header found, but does contains no-cache Pragma header, validation required";
                none$ = new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ requestContainsNoCache = none$;
        Option result = requestContainsNoCache.orElse((Function0 & Serializable)() -> CacheDirectives$.MODULE$.noCache(response.directives()).flatMap((Function1 & Serializable)noCache2 -> {
            Option<Seq<String>> option = noCache2.headerNames();
            if (option instanceof Some) {
                ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("noCacheFound: no-cache response directive qualified with " + noCache2.headerNames());
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                String msg = "Response contains no-args no-cache directive";
                return new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
            }
            throw new MatchError(option);
        }));
        return result;
    }

    public boolean containsPragmaNoCache(CacheRequest request) {
        return request.headers().get((Object)HeaderNames$.MODULE$.Pragma()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("no-cache")))));
    }

    public boolean headersFound(Seq<HeaderName> noCacheHeaders, StoredResponse response) {
        Set keySet = response.headers().keySet();
        return keySet.exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)noCacheHeaders.contains((Object)elem)));
    }

    public Option<ResponseServeActions.ServeFresh> isCachedResponseFresh(Seconds currentAge, CacheRequest request, StoredResponse response) {
        Some some;
        Seconds minFresh2;
        Some some2;
        Seconds maxAge2;
        if (ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("isCachedResponseFresh: request = " + request + ", response = " + response);
        }
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge);
        Option option = CacheDirectives$.MODULE$.maxAge(request.directives()).map((Function1 & Serializable)x$4 -> x$4.delta());
        if (option instanceof Some && currentAge.isGreaterThan(maxAge2 = (Seconds)(some2 = (Some)option).value())) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isCachedResponseFresh: maxAge = " + maxAge2 + ", currentAge = " + currentAge + ", not fresh enough.");
            return None$.MODULE$;
        }
        Option option2 = CacheDirectives$.MODULE$.minFresh(request.directives()).map((Function1 & Serializable)x$5 -> x$5.delta());
        if (option2 instanceof Some && !freshnessLifetime.isLessThan(currentAge.plus(minFresh2 = (Seconds)(some = (Some)option2).value()))) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge + ", minFresh = " + minFresh2);
            return new Some((Object)new ResponseServeActions.ServeFresh("Fresh response: minFresh = " + minFresh2 + ", freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge));
        }
        boolean responseIsFresh = freshnessLifetime.isGreaterThan(currentAge);
        ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isCachedResponseFresh: freshnessLifetime = " + freshnessLifetime + ", currentAge = " + currentAge);
        if (responseIsFresh) {
            Seconds secondsLeft = freshnessLifetime.minus(currentAge);
            String reason = "Fresh response: lifetime = " + freshnessLifetime + ", " + secondsLeft + " seconds left";
            return new Some((Object)new ResponseServeActions.ServeFresh(reason));
        }
        return None$.MODULE$;
    }

    public Option<ResponseServeActions.ServeStale> isStaleResponseAllowed(Seconds currentAge, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("isStaleResponseAllowed: " + currentAge + ", request = " + request + ", response = " + response);
        }
        Option result = CacheDirectives$.MODULE$.maxStale(request.directives()).flatMap((Function1 & Serializable)maxStale2 -> {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: maxStale = " + maxStale2);
            Option<Seconds> option = maxStale2.delta();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seconds maxStaleDelta = (Seconds)some.value();
                Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
                Seconds totalLifetime = freshnessLifetime.plus(maxStaleDelta);
                ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: freshnessLifetime = " + freshnessLifetime + ", maxAge = " + maxStaleDelta + ", totalLifetime = " + totalLifetime + ", currentAge = " + currentAge);
                if (totalLifetime.isGreaterThan(currentAge)) {
                    ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: (" + freshnessLifetime + " + " + maxStaleDelta + ") > = " + currentAge + ", allowing serve stale");
                    String msg = "Request contains " + maxStale2 + ", current age = " + currentAge.seconds() + " which is inside range";
                    return new Some((Object)new ResponseServeActions.ServeStale(msg));
                }
                ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: stale response outside of max-stale " + maxStale2);
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: maxStale has no delta, stale response allowed");
                String msg = "Request contains no-args max-stale directive";
                return new Some((Object)new ResponseServeActions.ServeStale(msg));
            }
            throw new MatchError(option);
        }).orElse((Function0 & Serializable)() -> {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: stale response not allowed");
            return None$.MODULE$;
        });
        return result;
    }

    public Option<ResponseServeActions.ValidateOrTimeout> isStaleResponseExplicitlyProhibited(CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("isStaleResponseProhibited: request = " + request + ", response = " + response);
        }
        if (response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$)) {
            return new Some((Object)new ResponseServeActions.ValidateOrTimeout("Response is stale, response contains must-revalidate directive"));
        }
        if (this.cache.isShared()) {
            if (response.directives().contains((Object)CacheDirectives$ProxyRevalidate$.MODULE$)) {
                String msg = "Response is stale, response contains proxy-revalidate directive and cache is shared";
                return new Some((Object)new ResponseServeActions.ValidateOrTimeout(msg));
            }
            if (CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined()) {
                String msg = "Response is stale, response contains s-maxage directive and cache is shared";
                return new Some((Object)new ResponseServeActions.ValidateOrTimeout(msg));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<ResponseServeActions.ServeStaleAndValidate> canServeStaleAndRevalidate(Seconds age, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().trace("canServeStaleAndRevalidate: response = " + response);
        }
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        return CacheDirectives$.MODULE$.staleWhileRevalidate(response.directives()).iterator().map((Function1 & Serializable)x$6 -> x$6.delta()).collectFirst((PartialFunction)new Serializable(null, age, freshnessLifetime){
            private static final long serialVersionUID = 0L;
            private final Seconds age$2;
            private final Seconds freshnessLifetime$2;

            public final <A1 extends Seconds, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.age$2.isLessThan(this.freshnessLifetime$2.plus(A1))) {
                    ResponseServingCalculator$.MODULE$.org$playframework$cachecontrol$ResponseServingCalculator$$logger().debug("canServeStaleAndRevalidate: age = " + this.age$2 + ", delta = " + A1);
                    String reason = "Response contains stale-while-revalidate and is within delta range " + A1;
                    return (B1)new ResponseServeActions.ServeStaleAndValidate(reason);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Seconds x1) {
                Seconds seconds = x1;
                return this.age$2.isLessThan(this.freshnessLifetime$2.plus(seconds));
            }
            {
                this.age$2 = age$2;
                this.freshnessLifetime$2 = freshnessLifetime$2;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$noCacheFound$1(CacheDirective x$1) {
        return x$1 instanceof CacheDirectives.NoCache;
    }

    public ResponseServingCalculator(Cache cache) {
        this.cache = cache;
        this.freshnessCalculator = new FreshnessCalculator(cache);
    }
}

