/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.spring.boot;

import java.util.Optional;
import java.util.Set;
import org.pkl.core.PNull;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Configuration
public class PklAutoConfiguration {
    public PklAutoConfiguration(ConfigurableEnvironment env) {
        env.getConversionService().addConverter((GenericConverter)new PNullConverter());
    }

    @Component
    @ConfigurationPropertiesBinding
    public static class PNullConverter
    implements GenericConverter {
        @Nullable
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Set.of(new GenericConverter.ConvertiblePair(PNull.class, Object.class));
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            assert (source == PNull.getInstance());
            return targetType.getType() == Optional.class ? Optional.empty() : null;
        }
    }
}

