/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.strings;

import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedConditionProfile;
import org.pkl.thirdparty.truffle.api.strings.AbstractInternalNode;
import org.pkl.thirdparty.truffle.api.strings.AbstractTruffleString;
import org.pkl.thirdparty.truffle.api.strings.TStringConstants;
import org.pkl.thirdparty.truffle.api.strings.TStringOps;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;

final class TStringOpsNodes {
    static final String LIMIT_STRIDE = "9";
    static final String SINGLE_LIMIT_STRIDE = "3";

    TStringOpsNodes() {
    }

    static int memcmp(Node location, AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB) {
        int cmp = TStringOps.memcmpWithStride(location, a, arrayA, a.stride(), b2, arrayB, b2.stride(), Math.min(a.length(), b2.length()));
        return TStringOpsNodes.memCmpTail(cmp, a.length(), b2.length());
    }

    static int memcmpBytes(Node location, AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB) {
        int cmp = TStringOps.memcmpBytesWithStride(location, a, arrayA, a.stride(), b2, arrayB, b2.stride(), Math.min(a.length(), b2.length()));
        return TStringOpsNodes.memCmpTail(cmp, a.length(), b2.length());
    }

    static int memCmpTail(int cmp, int lengthA, int lengthB) {
        return cmp == 0 ? lengthA - lengthB : cmp;
    }

    private static char[] removeValuesGreaterThan(Node location, char[] values2, int max2) {
        int n = 0;
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] <= max2) {
                ++n;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (n == values2.length) {
            return values2;
        }
        char[] clampedValues = new char[n];
        n = 0;
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] <= max2) {
                clampedValues[n++] = values2[i];
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return clampedValues;
    }

    private static int[] removeValuesGreaterThan(Node location, int[] values2, int max2) {
        int n = 0;
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] <= max2) {
                ++n;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        if (n == values2.length) {
            return values2;
        }
        int[] clampedValues = new int[n];
        n = 0;
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] <= max2) {
                clampedValues[n++] = values2[i];
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return clampedValues;
    }

    static abstract class CalculateHashCodeNode
    extends AbstractInternalNode {
        CalculateHashCodeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, Object arrayA, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.hashCodeWithStride(node, a, arrayA, cachedCompaction.getStride());
        }
    }

    static abstract class RawLastIndexOfStringNode
    extends AbstractInternalNode {
        RawLastIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, AbstractTruffleString var4, Object var5, int var6, int var7, byte[] var8);

        @Specialization(guards={"compactionA == cachedCompactionA", "compactionB == cachedCompactionB"}, limit="9")
        static int cachedLen1(Node node, AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB, int fromIndex, int toIndex, byte[] mask, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compactionA, @Cached(value="compactionA") TruffleString.CompactionLevel cachedCompactionA, @Bind(value="fromStride(b.stride())") TruffleString.CompactionLevel compactionB, @Cached(value="compactionB") TruffleString.CompactionLevel cachedCompactionB, @Cached InlinedConditionProfile oneLength) {
            if (oneLength.profile(node, b2.length() == 1)) {
                int b0 = TStringOps.readValue(b2, arrayB, cachedCompactionB.getStride(), 0);
                int mask0 = mask == null ? 0 : TStringOps.readFromByteArray(mask, cachedCompactionB.getStride(), 0);
                return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, a, arrayA, cachedCompactionA.getStride(), fromIndex, toIndex, b0, mask0);
            }
            return TStringOps.lastIndexOfStringWithOrMaskWithStride(node, a, arrayA, cachedCompactionA.getStride(), b2, arrayB, cachedCompactionB.getStride(), fromIndex, toIndex, mask);
        }
    }

    static abstract class RawIndexOfStringNode
    extends AbstractInternalNode {
        RawIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, AbstractTruffleString var4, Object var5, int var6, int var7, byte[] var8);

        @Specialization(guards={"compactionA == cachedCompactionA", "compactionB == cachedCompactionB"}, limit="9")
        static int doCached(Node node, AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB, int fromIndex, int toIndex, byte[] mask, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compactionA, @Cached(value="compactionA") TruffleString.CompactionLevel cachedCompactionA, @Bind(value="fromStride(b.stride())") TruffleString.CompactionLevel compactionB, @Cached(value="compactionB") TruffleString.CompactionLevel cachedCompactionB, @Cached InlinedConditionProfile oneLength) {
            if (oneLength.profile(node, b2.length() == 1)) {
                int b0 = TStringOps.readValue(b2, arrayB, cachedCompactionB.getStride(), 0);
                int mask0 = mask == null ? 0 : TStringOps.readFromByteArray(mask, cachedCompactionB.getStride(), 0);
                return TStringOps.indexOfCodePointWithOrMaskWithStride(node, a, arrayA, cachedCompactionA.getStride(), fromIndex, toIndex, b0, mask0);
            }
            return TStringOps.indexOfStringWithOrMaskWithStride(node, a, arrayA, cachedCompactionA.getStride(), b2, arrayB, cachedCompactionB.getStride(), fromIndex, toIndex, mask);
        }
    }

    static abstract class RawLastIndexOfCodePointNode
    extends AbstractInternalNode {
        RawLastIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, Object arrayA, int codepoint, int fromIndex, int toIndex, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, a, arrayA, cachedCompaction.getStride(), fromIndex, toIndex, codepoint, 0);
        }
    }

    static abstract class RawIndexOfCodePointNode
    extends AbstractInternalNode {
        RawIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, Object arrayA, int codepoint, int fromIndex, int toIndex, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.indexOfCodePointWithStride(node, a, arrayA, cachedCompaction.getStride(), fromIndex, toIndex, codepoint);
        }
    }

    static abstract class IndexOfAnyIntNode
    extends AbstractInternalNode {
        IndexOfAnyIntNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int[] var6);

        @Specialization(guards={"isStride0(a)", "values.length == 1"})
        int stride0(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, int[] values2) {
            return TStringOps.indexOfAnyInt((Node)this, a, arrayA, 0, fromIndex, maxIndex, values2);
        }

        @Specialization(guards={"isStride0(a)", "values.length > 1"})
        int stride0MultiValue(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, int[] values2) {
            return TStringOps.indexOfAnyInt((Node)this, a, arrayA, 0, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values2, 255));
        }

        @Specialization(guards={"isStride1(a)", "values.length == 1"})
        int stride1(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, int[] values2) {
            return TStringOps.indexOfAnyInt((Node)this, a, arrayA, 1, fromIndex, maxIndex, values2);
        }

        @Specialization(guards={"isStride1(a)", "values.length > 1"})
        int stride1MultiValue(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, int[] values2) {
            return TStringOps.indexOfAnyInt((Node)this, a, arrayA, 1, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values2, 65535));
        }

        @Specialization(guards={"isStride2(a)"})
        int stride2(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, int[] values2) {
            return TStringOps.indexOfAnyInt((Node)this, a, arrayA, 2, fromIndex, maxIndex, values2);
        }
    }

    static abstract class IndexOfAnyCharNode
    extends AbstractInternalNode {
        IndexOfAnyCharNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, char[] var6);

        @Specialization(guards={"isStride0(a)", "values.length == 1"})
        int stride0(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, char[] values2) {
            return TStringOps.indexOfAnyChar(this, a, arrayA, 0, fromIndex, maxIndex, values2);
        }

        @Specialization(guards={"isStride0(a)", "values.length > 1"})
        int stride0MultiValue(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, char[] values2) {
            return TStringOps.indexOfAnyChar(this, a, arrayA, 0, fromIndex, maxIndex, TStringOpsNodes.removeValuesGreaterThan((Node)this, values2, 255));
        }

        @Specialization(guards={"isStride1(a)"})
        int stride1(AbstractTruffleString a, Object arrayA, int fromIndex, int maxIndex, char[] values2) {
            return TStringOps.indexOfAnyChar(this, a, arrayA, 1, fromIndex, maxIndex, values2);
        }
    }

    static abstract class RawReadValueNode
    extends AbstractInternalNode {
        RawReadValueNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4);

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static int cached(Node node, AbstractTruffleString a, Object arrayA, int i, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) {
            return TStringOps.readValue(a, arrayA, cachedCompaction.getStride(), i);
        }
    }
}

