/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.staticobject;

final class GeneratorClassLoaders {
    private final StorageClassLoader storageCL;
    private final FactoryClassLoader factoryCL;

    GeneratorClassLoaders(Class<?> referenceClass) {
        this.storageCL = new StorageClassLoader(referenceClass);
        this.factoryCL = new FactoryClassLoader(this.storageCL);
    }

    Class<?> defineGeneratedClass(String name, byte[] b2, int off, int len, boolean isStorage) throws ClassFormatError {
        if (isStorage) {
            return this.storageCL.defineGeneratedClass(name, b2, off, len);
        }
        return this.factoryCL.defineGeneratedClass(name, b2, off, len);
    }

    private final class StorageClassLoader
    extends ClassLoader {
        private final Class<?> referenceClass;

        StorageClassLoader(Class<?> referenceClass) {
            super(referenceClass.getClassLoader());
            this.referenceClass = referenceClass;
        }

        Class<?> defineGeneratedClass(String name, byte[] b2, int off, int len) throws ClassFormatError {
            return this.defineClass(name, b2, off, len, this.referenceClass.getProtectionDomain());
        }
    }

    private final class FactoryClassLoader
    extends ClassLoader {
        FactoryClassLoader(StorageClassLoader parent) {
            super(parent);
        }

        Class<?> defineGeneratedClass(String name, byte[] b2, int off, int len) throws ClassFormatError {
            return this.defineClass(name, b2, off, len, ((StorageClassLoader)this.getParent()).referenceClass.getProtectionDomain());
        }
    }
}

