/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.AbstractInlinedValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.ByteValueProfile;
import org.pkl.thirdparty.truffle.api.profiles.Profile;

public final class InlinedByteValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedByteValueProfile DISABLED;
    private final InlineSupport.ByteField cachedValue;

    private InlinedByteValueProfile() {
        this.cachedValue = null;
    }

    private InlinedByteValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getPrimitive(1, InlineSupport.ByteField.class);
    }

    public byte profile(Node node, byte value2) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            byte v;
            if (localState == 1 && (v = this.cachedValue.get(node)) == value2) {
                return v;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.state.set(node, 1);
                this.cachedValue.set(node, value2);
            } else {
                this.state.set(node, 2);
                this.cachedValue.set(node, (byte)0);
            }
        }
        return value2;
    }

    byte getCachedValue(Node node) {
        return this.cachedValue.get(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(ByteValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (byte)%s", this.getCachedValue(node)));
    }

    public static InlinedByteValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.ByteField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedByteValueProfile(target);
        }
        return InlinedByteValueProfile.getUncached();
    }

    public static InlinedByteValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedByteValueProfile profile;
        DISABLED = profile = new InlinedByteValueProfile();
    }
}

