/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.debug;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.debug.Breakpoint;
import org.pkl.thirdparty.truffle.api.debug.DebuggerSession;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.GenerateInline;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;

@GenerateInline(value=false)
abstract class SetThreadSuspensionEnabledNode
extends Node {
    static final int CACHE_LIMIT = 10;

    SetThreadSuspensionEnabledNode() {
    }

    public final void execute(boolean suspensionEnabled, Breakpoint.SessionList sessions) {
        this.execute(suspensionEnabled, sessions, SetThreadSuspensionEnabledNode.currentThreadId());
    }

    protected abstract void execute(boolean var1, Breakpoint.SessionList var2, long var3);

    @Specialization(guards={"sessions.next == null", "threadId == currentThreadId"}, limit="CACHE_LIMIT")
    protected void doCached(boolean suspensionEnabled, Breakpoint.SessionList sessions, long threadId, @Cached(value="currentThreadId()") long currentThreadId, @Cached(value="getThreadSuspension(sessions)") DebuggerSession.ThreadSuspension threadSuspension) {
        threadSuspension.enabled = suspensionEnabled;
    }

    @ExplodeLoop
    @Specialization(replaces={"doCached"})
    protected void doGeneric(boolean suspensionEnabled, Breakpoint.SessionList sessions, long threadId) {
        Breakpoint.SessionList current2 = sessions;
        while (current2 != null) {
            current2.session.setThreadSuspendEnabled(suspensionEnabled);
            current2 = current2.next;
        }
    }

    static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    @CompilerDirectives.TruffleBoundary
    protected DebuggerSession.ThreadSuspension getThreadSuspension(Breakpoint.SessionList sessions) {
        assert (sessions.next == null);
        DebuggerSession.ThreadSuspension threadSuspension = new DebuggerSession.ThreadSuspension(true);
        sessions.session.threadSuspensions.set(threadSuspension);
        return threadSuspension;
    }
}

