/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.xform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.collections.MutList;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;
import org.pkl.thirdparty.paguro.function.Fn1;
import org.pkl.thirdparty.paguro.function.Fn2;
import org.pkl.thirdparty.paguro.oneOf.Or;

public abstract class Xform<A>
implements UnmodIterable<A> {
    @NotNull
    private static final Object TERMINATE = new Object();
    @NotNull
    public static final Xform EMPTY = new SourceProviderIterableDesc(Collections.emptyList());
    final Xform prevOp;

    @NotNull
    private A terminate() {
        return (A)TERMINATE;
    }

    @NotNull
    public static <T> Xform<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> Xform<T> of(@Nullable Iterable<? extends T> list) {
        if (list == null) {
            return Xform.empty();
        }
        return new SourceProviderIterableDesc<T>(list);
    }

    Xform(Xform pre) {
        this.prevOp = pre;
    }

    private static <H> H _fold(@NotNull Iterable source, @NotNull @NotNull Operation @NotNull [] ops, int opIdx, H ident, @NotNull Fn2 reducer) {
        Object ret = ident;
        block0: for (Object o : source) {
            for (int j = opIdx; j < ops.length; ++j) {
                Operation op = ops[j];
                if (op.filter != null && !op.filter.apply(o).booleanValue()) continue block0;
                if (op.map != null) {
                    if ((o = op.map.apply(o)) != TERMINATE) continue;
                    return ret;
                }
                if (op.flatMap == null) continue;
                ret = Xform._fold(op.flatMap.apply(o), ops, j + 1, ret, reducer);
                continue block0;
            }
            ret = reducer.apply(ret, o);
        }
        return ret;
    }

    @Override
    @NotNull
    public UnmodIterator<A> iterator() {
        return this.toMutList().iterator();
    }

    @Override
    @NotNull
    public Xform<A> concat(@Nullable Iterable<? extends A> list) {
        return new AppendIterDesc<A>(this, new SourceProviderIterableDesc<A>(list));
    }

    @Override
    @NotNull
    public Xform<A> precat(@Nullable Iterable<? extends A> list) {
        return new AppendIterDesc<A>(Xform.of(list), this);
    }

    @Override
    @NotNull
    public Xform<A> drop(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Can't drop less than zero items.");
        }
        return new DropDesc(this, n);
    }

    @Override
    @NotNull
    public Xform<A> dropWhile(@NotNull Fn1<? super A, Boolean> predicate) {
        return new DropWhileDesc<A>(this, predicate);
    }

    @Override
    public <B> B fold(B ident, @NotNull Fn2<? super B, ? super A, B> reducer) {
        RunList runList = this.toRunList();
        return Xform._fold(runList, runList.opArray(), 0, ident, reducer);
    }

    @Override
    @NotNull
    public <G, B> Or<G, B> foldUntil(G accum, @Nullable Fn2<? super G, ? super A, B> terminator, @NotNull Fn2<? super G, ? super A, G> reducer) {
        if (terminator == null) {
            return Or.good(this.fold((B)accum, (Fn2<? super B, ? super A, B>)reducer));
        }
        MutList as = this.toMutList();
        for (Object a : as) {
            B term = terminator.apply(accum, (G)a);
            if (term != null) {
                return Or.bad(term);
            }
            accum = reducer.apply(accum, (G)a);
        }
        return Or.good(accum);
    }

    @Override
    @NotNull
    public Xform<A> filter(@NotNull Fn1<? super A, Boolean> f) {
        return new FilterDesc<A>(this, f);
    }

    @Override
    @NotNull
    public <B> Xform<B> flatMap(@NotNull Fn1<? super A, Iterable<B>> f) {
        return new FlatMapDesc<A, B>(this, f);
    }

    @Override
    @NotNull
    public <B> Xform<B> map(@NotNull Fn1<? super A, ? extends B> f) {
        return new MapDesc<A, B>(this, f);
    }

    @NotNull
    protected abstract RunList toRunList();

    @Override
    @NotNull
    public Xform<A> take(long numItems) {
        if (numItems < 0L) {
            throw new IllegalArgumentException("Num items must be >= 0");
        }
        return new TakeDesc(this, numItems);
    }

    @Override
    @NotNull
    public Xform<A> takeWhile(@NotNull Fn1<? super A, Boolean> f) {
        return new MapDesc<Object, Object>(this, a -> (Boolean)f.apply((A)a) != false ? a : this.terminate());
    }

    static final class SourceProviderIterableDesc<T>
    extends Xform<T> {
        private final Iterable<? extends T> list;

        SourceProviderIterableDesc(Iterable<? extends T> l) {
            super(null);
            this.list = l;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            return new RunList(null, this.list);
        }

        public int hashCode() {
            return UnmodIterable.hash(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceProviderIterableDesc)) {
                return false;
            }
            return Objects.equals(this.list, ((SourceProviderIterableDesc)other).list);
        }
    }

    private static final class TakeDesc<T>
    extends Xform<T> {
        private final long take;

        TakeDesc(Xform<T> prev, long t) {
            super(prev);
            this.take = t;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            Operation op;
            OpStrategy earlierTs;
            RunList ret = this.prevOp.toRunList();
            for (int i = ret.list.size() - 1; i >= 0 && (earlierTs = (op = ret.list.get(i)).take(this.take)) != OpStrategy.CANNOT_HANDLE; --i) {
                if (earlierTs != OpStrategy.HANDLE_INTERNALLY) continue;
                return ret;
            }
            ret.list.add(new Operation.TakeOp(this.take));
            return ret;
        }
    }

    private static final class FlatMapDesc<T, U>
    extends Xform<U> {
        final Fn1<? super T, Iterable<U>> f;

        FlatMapDesc(Xform<T> prev, Fn1<? super T, Iterable<U>> func) {
            super(prev);
            this.f = func;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FlatMapOp(this.f));
            return ret;
        }
    }

    private static final class MapDesc<T, U>
    extends Xform<U> {
        final Fn1<? super T, ? extends U> f;

        MapDesc(Xform<T> prev, Fn1<? super T, ? extends U> func) {
            super(prev);
            this.f = func;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.MapOp(this.f));
            return ret;
        }
    }

    private static final class FilterDesc<T>
    extends Xform<T> {
        final Fn1<? super T, Boolean> f;

        FilterDesc(Xform<T> prev, Fn1<? super T, Boolean> func) {
            super(prev);
            this.f = func;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FilterOp(this.f));
            return ret;
        }
    }

    private static final class DropWhileDesc<T>
    extends Xform<T> {
        final Fn1<? super T, Boolean> f;

        DropWhileDesc(Xform<T> prev, Fn1<? super T, Boolean> func) {
            super(prev);
            this.f = func;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            RunList ret = this.prevOp.toRunList();
            ret.list.add(new Operation.FilterOp(new Fn1<Object, Boolean>(){
                private boolean active = true;

                @Override
                public Boolean applyEx(Object o) {
                    boolean ret;
                    if (!this.active) {
                        return true;
                    }
                    boolean bl = ret = f.apply(o) == false;
                    if (ret) {
                        this.active = false;
                    }
                    return ret;
                }
            }));
            return ret;
        }
    }

    private static final class DropDesc<T>
    extends Xform<T> {
        private final long dropAmt;

        DropDesc(Xform<T> prev, long d2) {
            super(prev);
            this.dropAmt = d2;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            Operation op;
            Or<Long, OpStrategy> earlierDs;
            RunList ret = this.prevOp.toRunList();
            for (int i = ret.list.size() - 1; !(i < 0 || (earlierDs = (op = ret.list.get(i)).drop(this.dropAmt)).isBad() && earlierDs.bad() == OpStrategy.CANNOT_HANDLE); --i) {
                if (!earlierDs.isGood()) continue;
                return ret;
            }
            ret.list.add(new Operation.DropOp(this.dropAmt));
            return ret;
        }
    }

    private static final class AppendIterDesc<T>
    extends Xform<T> {
        final Xform<T> src;

        AppendIterDesc(Xform<T> prev, Xform<T> s2) {
            super(prev);
            this.src = s2;
        }

        @Override
        @NotNull
        protected RunList toRunList() {
            return new AppendOp(this.prevOp.toRunList(), this.src);
        }
    }

    private static final class AppendOp
    extends RunList {
        private AppendOp(RunList prv, Iterable src) {
            super(prv, src);
        }

        @Override
        @NotNull
        public Iterator iterator() {
            final ArrayList prevSrc = Xform._fold(this.prev, this.prev.opArray(), 0, new ArrayList(), new Fn2<ArrayList, Object, ArrayList>(){

                @Override
                @NotNull
                public ArrayList applyEx(@NotNull ArrayList res, Object item) {
                    res.add(item);
                    return res;
                }
            });
            return new Iterator(){
                @NotNull
                Iterator innerIter;
                boolean usingPrevSrc;
                {
                    this.innerIter = prevSrc.iterator();
                    this.usingPrevSrc = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.innerIter.hasNext()) {
                        return true;
                    }
                    if (this.usingPrevSrc) {
                        this.usingPrevSrc = false;
                        this.innerIter = source.iterator();
                    }
                    return this.innerIter.hasNext();
                }

                public Object next() {
                    return this.innerIter.next();
                }
            };
        }
    }

    protected static class RunList
    implements Iterable {
        final Iterable source;
        final List<Operation> list = new ArrayList<Operation>();
        final RunList prev;

        private RunList(RunList prv, Iterable src) {
            this.prev = prv;
            this.source = src;
        }

        @NotNull
        @NotNull Operation @NotNull [] opArray() {
            return this.list.toArray(new Operation[0]);
        }

        @NotNull
        public Iterator iterator() {
            return this.source.iterator();
        }
    }

    static abstract class Operation {
        @Nullable
        Fn1<Object, Boolean> filter = null;
        @Nullable
        Fn1 map = null;
        @Nullable
        Fn1<Object, Iterable> flatMap = null;

        Operation() {
        }

        @NotNull
        public Or<Long, OpStrategy> drop(long num) {
            return num < 1L ? Or.good(0L) : Or.bad(OpStrategy.CANNOT_HANDLE);
        }

        @NotNull
        public OpStrategy take(long num) {
            return OpStrategy.CANNOT_HANDLE;
        }

        private static final class TakeOp
        extends Operation {
            private long numToTake;

            TakeOp(long take2) {
                this.numToTake = take2;
                this.map = a -> {
                    if (this.numToTake > 0L) {
                        --this.numToTake;
                        return a;
                    }
                    return TERMINATE;
                };
            }

            @Override
            @NotNull
            public OpStrategy take(long num) {
                if (num < this.numToTake) {
                    this.numToTake = num;
                }
                return OpStrategy.HANDLE_INTERNALLY;
            }
        }

        private static final class FlatMapOp
        extends Operation {
            FlatMapOp(Fn1<Object, Iterable> func) {
                this.flatMap = func;
            }
        }

        private static final class MapOp
        extends Operation {
            MapOp(Fn1 func) {
                this.map = func;
            }

            @Override
            @NotNull
            public Or<Long, OpStrategy> drop(long num) {
                return Or.bad(OpStrategy.ASK_SUPPLIER);
            }

            @Override
            @NotNull
            public OpStrategy take(long num) {
                return OpStrategy.ASK_SUPPLIER;
            }
        }

        private static final class FilterOp
        extends Operation {
            FilterOp(Fn1<Object, Boolean> func) {
                this.filter = func;
            }
        }

        private static final class DropOp
        extends Operation {
            private long leftToDrop;

            DropOp(long drop2) {
                this.leftToDrop = drop2;
                this.filter = o -> {
                    if (this.leftToDrop > 0L) {
                        --this.leftToDrop;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                };
            }

            @Override
            @NotNull
            public Or<Long, OpStrategy> drop(long num) {
                this.leftToDrop += num;
                return Or.good(num);
            }
        }
    }

    static enum OpStrategy {
        HANDLE_INTERNALLY,
        ASK_SUPPLIER,
        CANNOT_HANDLE;

    }
}

