/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.xform;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.collections.ImList;
import org.pkl.thirdparty.paguro.collections.ImMap;
import org.pkl.thirdparty.paguro.collections.ImSet;
import org.pkl.thirdparty.paguro.collections.ImSortedMap;
import org.pkl.thirdparty.paguro.collections.ImSortedSet;
import org.pkl.thirdparty.paguro.collections.MutList;
import org.pkl.thirdparty.paguro.collections.MutMap;
import org.pkl.thirdparty.paguro.collections.MutSet;
import org.pkl.thirdparty.paguro.collections.PersistentHashMap;
import org.pkl.thirdparty.paguro.collections.PersistentHashSet;
import org.pkl.thirdparty.paguro.collections.PersistentTreeMap;
import org.pkl.thirdparty.paguro.collections.PersistentTreeSet;
import org.pkl.thirdparty.paguro.collections.PersistentVector;
import org.pkl.thirdparty.paguro.collections.RrbTree;
import org.pkl.thirdparty.paguro.function.Fn1;
import org.pkl.thirdparty.paguro.function.Fn2;
import org.pkl.thirdparty.paguro.oneOf.Option;
import org.pkl.thirdparty.paguro.oneOf.Or;

public interface Transformable<T> {
    default public boolean any(@NotNull Fn1<? super T, Boolean> predicate) {
        return this.filter(predicate).head().isSome();
    }

    @NotNull
    public Transformable<T> concat(@Nullable Iterable<? extends T> var1);

    @NotNull
    public Transformable<T> drop(long var1);

    @NotNull
    public Transformable<T> dropWhile(@NotNull Fn1<? super T, Boolean> var1);

    @NotNull
    public Transformable<T> filter(@NotNull Fn1<? super T, Boolean> var1);

    @NotNull
    public @NotNull Transformable<@NotNull T> whereNonNull();

    @NotNull
    default public Option<T> head() {
        return this.foldUntil(Option.none(), (accum, item) -> Option.someOrNullNoneOf(item), Fn2.first()).match(g -> Option.none(), b2 -> b2);
    }

    @NotNull
    public <U> Transformable<U> flatMap(@NotNull Fn1<? super T, Iterable<U>> var1);

    public <U> U fold(U var1, @NotNull Fn2<? super U, ? super T, U> var2);

    @NotNull
    public <G, B> Or<G, B> foldUntil(G var1, @Nullable Fn2<? super G, ? super T, B> var2, @NotNull Fn2<? super G, ? super T, G> var3);

    @NotNull
    public <U> Transformable<U> map(@NotNull Fn1<? super T, ? extends U> var1);

    @NotNull
    public Transformable<T> precat(@Nullable Iterable<? extends T> var1);

    @NotNull
    public Transformable<T> take(long var1);

    @NotNull
    public Transformable<T> takeWhile(@NotNull Fn1<? super T, Boolean> var1);

    @NotNull
    default public ImList<T> toImList() {
        return this.toMutList().immutable();
    }

    @NotNull
    default public RrbTree.ImRrbt<T> toImRrbt() {
        return this.toMutRrbt().immutable();
    }

    @NotNull
    default public <K, V> ImMap<K, V> toImMap(@NotNull Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.toMutMap(f1).immutable();
    }

    @NotNull
    default public ImSet<T> toImSet() {
        return this.toMutSet().immutable();
    }

    @NotNull
    default public <K, V> ImSortedMap<K, V> toImSortedMap(Comparator<? super K> comp, @NotNull Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(PersistentTreeMap.empty(comp), (ts, t) -> ts.assoc((Map.Entry)f1.apply(t)));
    }

    @NotNull
    default public ImSortedSet<T> toImSortedSet(Comparator<? super T> comparator) {
        return this.fold(PersistentTreeSet.ofComp(comparator), PersistentTreeSet::put);
    }

    @NotNull
    default public MutList<T> toMutList() {
        return this.fold(PersistentVector.emptyMutable(), MutList::append);
    }

    @NotNull
    default public RrbTree.MutRrbt<T> toMutRrbt() {
        return this.fold(RrbTree.emptyMutable(), RrbTree.MutRrbt::append);
    }

    @NotNull
    default public <K, V> MutMap<K, V> toMutMap(@NotNull Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(PersistentHashMap.emptyMutable(), (ts, t) -> ts.assoc((Map.Entry)f1.apply(t)));
    }

    @NotNull
    default public <K, V> SortedMap<K, V> toMutSortedMap(@Nullable Comparator<? super K> comp, @NotNull Fn1<? super T, Map.Entry<K, V>> f1) {
        return this.fold(new TreeMap(comp), (ts, t) -> {
            Map.Entry entry = (Map.Entry)f1.apply(t);
            ts.put(entry.getKey(), entry.getValue());
            return ts;
        });
    }

    @NotNull
    default public MutSet<T> toMutSet() {
        return this.fold(PersistentHashSet.emptyMutable(), PersistentHashSet.MutHashSet::put);
    }

    @NotNull
    default public SortedSet<T> toMutSortedSet(@Nullable Comparator<? super T> comparator) {
        return this.fold(new TreeSet<T>(comparator), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }
}

