/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.type;

import java.util.HashMap;
import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.FunctionUtils;
import org.pkl.thirdparty.paguro.StaticImports;
import org.pkl.thirdparty.paguro.collections.ImList;

public final class RuntimeTypes {
    @NotNull
    private static final ListAndMap root = new ListAndMap(StaticImports.vec(new Class[0]));

    @Deprecated
    private RuntimeTypes() {
        throw new UnsupportedOperationException("No instantiation");
    }

    @NotNull
    public static ImList<Class> registerClasses(Class ... cs) {
        ListAndMap node = root;
        for (Class currClass : cs) {
            node = node.next(currClass);
        }
        return node.list;
    }

    @NotNull
    public static String name(@Nullable Class c) {
        return c == null ? "null" : c.getSimpleName();
    }

    @NotNull
    public static String union2Str(Object item, @NotNull ImList<Class> types) {
        StringBuilder sB = new StringBuilder();
        sB.append(FunctionUtils.stringify(item)).append(":");
        boolean isFirst = true;
        for (Class c : types) {
            if (isFirst) {
                isFirst = false;
            } else {
                sB.append("|");
            }
            sB.append(RuntimeTypes.name(c));
        }
        return sB.toString();
    }

    private static class ListAndMap {
        @NotNull
        public final ImList<Class> list;
        @NotNull
        private final Map<Class, ListAndMap> map = new HashMap<Class, ListAndMap>();

        public ListAndMap(@NotNull ImList<Class> l) {
            this.list = l;
        }

        public synchronized ListAndMap next(@NotNull Class currClass) {
            ListAndMap next = this.map.get(currClass);
            if (next == null) {
                next = new ListAndMap((ImList<Class>)this.list.append((Object)currClass));
                this.map.put(currClass, next);
            }
            return next;
        }
    }
}

