/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.oneOf;

import java.util.Objects;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.FunctionUtils;
import org.pkl.thirdparty.paguro.function.Fn1;

public interface Or<G, B> {
    @NotNull
    public static <G, B> Or<G, B> good(G good) {
        return new Good(good);
    }

    @NotNull
    public static <G, B> Or<G, B> bad(B bad) {
        return new Bad(bad);
    }

    public boolean isGood();

    public boolean isBad();

    public G good();

    public B bad();

    public <R> R match(@NotNull Fn1<G, R> var1, @NotNull Fn1<B, R> var2);

    public static final class Bad<G, B>
    implements Or<G, B> {
        private final B b;

        private Bad(B bad) {
            this.b = bad;
        }

        @Override
        public boolean isGood() {
            return false;
        }

        @Override
        public boolean isBad() {
            return true;
        }

        @Override
        public G good() {
            throw new IllegalStateException("Cant call good() on a Bad.");
        }

        @Override
        public B bad() {
            return this.b;
        }

        @Override
        public <R> R match(@NotNull Fn1<G, R> fg, @NotNull Fn1<B, R> fb) {
            return fb.apply(this.b);
        }

        public int hashCode() {
            return ~this.b.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Bad && Objects.equals(this.b, ((Bad)other).b);
        }

        @NotNull
        public String toString() {
            return "Bad(" + FunctionUtils.stringify(this.b) + ")";
        }
    }

    public static final class Good<G, B>
    implements Or<G, B> {
        private final G g;

        private Good(G good) {
            this.g = good;
        }

        @Override
        public boolean isGood() {
            return true;
        }

        @Override
        public boolean isBad() {
            return false;
        }

        @Override
        public G good() {
            return this.g;
        }

        @Override
        public B bad() {
            throw new IllegalStateException("Cant call bad() on a Good.");
        }

        @Override
        public <R> R match(@NotNull Fn1<G, R> fg, @NotNull Fn1<B, R> fb) {
            return fg.apply(this.g);
        }

        public int hashCode() {
            return this.g.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Good && Objects.equals(this.g, ((Good)other).g);
        }

        @NotNull
        public String toString() {
            return "Good(" + FunctionUtils.stringify(this.g) + ")";
        }
    }
}

