/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.polyglot;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.stream.StreamSupport;
import org.pkl.thirdparty.graalvm.polyglot.Engine;
import org.pkl.thirdparty.graalvm.polyglot.EnvironmentAccess;
import org.pkl.thirdparty.graalvm.polyglot.HostAccess;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotAccess;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotException;
import org.pkl.thirdparty.graalvm.polyglot.ResourceLimits;
import org.pkl.thirdparty.graalvm.polyglot.SandboxPolicy;
import org.pkl.thirdparty.graalvm.polyglot.Source;
import org.pkl.thirdparty.graalvm.polyglot.Value;
import org.pkl.thirdparty.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.pkl.thirdparty.graalvm.polyglot.io.FileSystem;
import org.pkl.thirdparty.graalvm.polyglot.io.IOAccess;
import org.pkl.thirdparty.graalvm.polyglot.io.MessageTransport;
import org.pkl.thirdparty.graalvm.polyglot.io.ProcessHandler;

public final class Context
implements AutoCloseable {
    final AbstractPolyglotImpl.AbstractContextDispatch dispatch;
    final Object receiver;
    final Context currentAPI;
    final Engine engine;
    private static final Context EMPTY = new Context();
    static final Predicate<String> UNSET_HOST_LOOKUP = new Predicate<String>(){

        @Override
        public boolean test(String t) {
            return false;
        }
    };
    static final Predicate<String> NO_HOST_CLASSES = new Predicate<String>(){

        @Override
        public boolean test(String t) {
            return false;
        }
    };
    static final Predicate<String> ALL_HOST_CLASSES = new Predicate<String>(){

        @Override
        public boolean test(String t) {
            return true;
        }
    };

    <T> Context(AbstractPolyglotImpl.AbstractContextDispatch dispatch, T receiver, Engine engine) {
        this.dispatch = dispatch;
        this.receiver = receiver;
        this.engine = engine;
        this.currentAPI = new Context(this);
        dispatch.setAPI(receiver, this);
    }

    private Context() {
        this.dispatch = null;
        this.receiver = null;
        this.engine = null;
        this.currentAPI = null;
    }

    private <T> Context(Context creatorAPI) {
        this.dispatch = creatorAPI.dispatch;
        this.receiver = creatorAPI.receiver;
        this.engine = creatorAPI.engine.currentAPI;
        this.currentAPI = null;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Value eval(Source source) {
        return this.dispatch.eval(this.receiver, source.getLanguage(), source);
    }

    public Value eval(String languageId, CharSequence source) {
        return this.eval(Source.create(languageId, source));
    }

    public Value parse(Source source) throws PolyglotException {
        return this.dispatch.parse(this.receiver, source.getLanguage(), source);
    }

    public Value parse(String languageId, CharSequence source) {
        return this.parse(Source.create(languageId, source));
    }

    public Value getPolyglotBindings() {
        return this.dispatch.getPolyglotBindings(this.receiver);
    }

    public Value getBindings(String languageId) {
        return this.dispatch.getBindings(this.receiver, languageId);
    }

    public boolean initialize(String languageId) {
        return this.dispatch.initializeLanguage(this.receiver, languageId);
    }

    public void resetLimits() {
        this.dispatch.resetLimits(this.receiver);
    }

    public Value asValue(Object hostValue) {
        return this.dispatch.asValue(this.receiver, hostValue);
    }

    public void enter() {
        this.checkCreatorAccess("entered");
        this.dispatch.explicitEnter(this.receiver);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Context) {
            Context other = (Context)obj;
            return this.receiver.equals(other.receiver);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.receiver);
    }

    public void leave() {
        this.checkCreatorAccess("left");
        this.dispatch.explicitLeave(this.receiver);
    }

    private void checkCreatorAccess(String operation) {
        if (this.currentAPI == null) {
            throw new IllegalStateException(String.format("Context instances that were received using Context.get() cannot be %s.", operation));
        }
    }

    public void close(boolean cancelIfExecuting) {
        this.checkCreatorAccess("closed");
        this.dispatch.close(this.receiver, cancelIfExecuting);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void interrupt(Duration timeout) throws TimeoutException {
        this.checkCreatorAccess("interrupted");
        if (!this.dispatch.interrupt(this.receiver, timeout)) {
            throw new TimeoutException("Interrupt timed out.");
        }
    }

    public void safepoint() {
        this.dispatch.safepoint(this.receiver);
    }

    public static Context getCurrent() {
        Context context = Engine.getImpl().getCurrentContext();
        if (context.currentAPI == null) {
            return context;
        }
        return context.currentAPI;
    }

    public static Context create(String ... permittedLanguages) {
        return Context.newBuilder(permittedLanguages).build();
    }

    public static Builder newBuilder(String ... permittedLanguages) {
        Context context = EMPTY;
        Objects.requireNonNull(context);
        return context.new Builder(permittedLanguages);
    }

    public final class Builder {
        private Engine sharedEngine;
        private String[] permittedLanguages;
        private OutputStream out;
        private OutputStream err;
        private InputStream in;
        private Map<String, String> options;
        private Map<String, String[]> arguments;
        private Predicate<String> hostClassFilter = UNSET_HOST_LOOKUP;
        private Boolean allowNativeAccess;
        private Boolean allowCreateThread;
        private boolean allowAllAccess;
        private Boolean allowIO;
        private Boolean allowHostClassLoading;
        private Boolean allowExperimentalOptions;
        private Boolean allowHostAccess;
        private boolean allowValueSharing = true;
        private Boolean allowInnerContextOptions;
        private PolyglotAccess polyglotAccess;
        private HostAccess hostAccess;
        private IOAccess ioAccess;
        private FileSystem customFileSystem;
        private MessageTransport messageTransport;
        private Object customLogHandler;
        private Boolean allowCreateProcess;
        private ProcessHandler processHandler;
        private EnvironmentAccess environmentAccess;
        private ResourceLimits resourceLimits;
        private Map<String, String> environment;
        private ZoneId zone;
        private Path currentWorkingDirectory;
        private ClassLoader hostClassLoader;
        private boolean useSystemExit;
        private SandboxPolicy sandboxPolicy;

        Builder(String ... permittedLanguages) {
            Objects.requireNonNull(permittedLanguages);
            for (String language : permittedLanguages) {
                Objects.requireNonNull(language);
            }
            this.permittedLanguages = permittedLanguages;
        }

        public Builder engine(Engine engine) {
            Objects.requireNonNull(engine);
            this.sharedEngine = engine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        @Deprecated(since="19.0")
        public Builder allowHostAccess(boolean enabled) {
            this.allowHostAccess = enabled;
            return this;
        }

        public Builder allowHostAccess(HostAccess config) {
            this.hostAccess = config;
            return this;
        }

        public Builder allowNativeAccess(boolean enabled) {
            this.allowNativeAccess = enabled;
            return this;
        }

        public Builder allowCreateThread(boolean enabled) {
            this.allowCreateThread = enabled;
            return this;
        }

        public Builder allowAllAccess(boolean enabled) {
            this.allowAllAccess = enabled;
            return this;
        }

        public Builder allowHostClassLoading(boolean enabled) {
            this.allowHostClassLoading = enabled;
            return this;
        }

        public Builder allowHostClassLookup(Predicate<String> classFilter) {
            this.hostClassFilter = classFilter;
            return this;
        }

        public Builder allowExperimentalOptions(boolean enabled) {
            this.allowExperimentalOptions = enabled;
            return this;
        }

        public Builder allowPolyglotAccess(PolyglotAccess accessPolicy) {
            Objects.requireNonNull(accessPolicy);
            this.polyglotAccess = accessPolicy;
            return this;
        }

        public Builder allowValueSharing(boolean enabled) {
            this.allowValueSharing = enabled;
            return this;
        }

        public Builder allowInnerContextOptions(boolean enabled) {
            this.allowInnerContextOptions = enabled;
            return this;
        }

        @Deprecated(since="19.0")
        public Builder hostClassFilter(Predicate<String> classFilter) {
            Objects.requireNonNull(classFilter);
            this.hostClassFilter = classFilter;
            return this;
        }

        public Builder option(String key2, String value2) {
            Objects.requireNonNull(key2);
            Objects.requireNonNull(value2);
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(key2, value2);
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.option(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder arguments(String language, String[] args) {
            Objects.requireNonNull(language);
            Objects.requireNonNull(args);
            String[] newArgs = args;
            if (args.length > 0) {
                newArgs = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    newArgs[i] = Objects.requireNonNull(args[i]);
                }
            }
            if (this.arguments == null) {
                this.arguments = new HashMap<String, String[]>();
            }
            this.arguments.put(language, newArgs);
            return this;
        }

        public Builder allowIO(IOAccess ioAccess) {
            this.ioAccess = ioAccess;
            return this;
        }

        @Deprecated(since="23.0")
        public Builder allowIO(boolean enabled) {
            this.allowIO = enabled;
            return this;
        }

        @Deprecated(since="23.0")
        public Builder fileSystem(FileSystem fileSystem) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.customFileSystem = fileSystem;
            return this;
        }

        public Builder serverTransport(MessageTransport serverTransport) {
            Objects.requireNonNull(serverTransport, "MessageTransport must be non null.");
            this.messageTransport = serverTransport;
            return this;
        }

        public Builder logHandler(Handler logHandler) {
            Objects.requireNonNull(logHandler, "Handler must be non null.");
            this.customLogHandler = logHandler;
            return this;
        }

        public Builder timeZone(ZoneId zone) {
            this.zone = zone;
            return this;
        }

        public Builder logHandler(OutputStream logOut) {
            Objects.requireNonNull(logOut, "LogOut must be non null.");
            this.customLogHandler = logOut;
            return this;
        }

        public Builder allowCreateProcess(boolean enabled) {
            this.allowCreateProcess = enabled;
            return this;
        }

        public Builder processHandler(ProcessHandler handler) {
            Objects.requireNonNull(handler, "Handler must be non null.");
            this.processHandler = handler;
            return this;
        }

        public Builder resourceLimits(ResourceLimits limits) {
            this.resourceLimits = limits;
            return this;
        }

        public Builder sandbox(SandboxPolicy policy) {
            Engine.validateSandboxPolicy(this.sandboxPolicy, policy);
            this.sandboxPolicy = policy;
            return this;
        }

        public Builder allowEnvironmentAccess(EnvironmentAccess accessPolicy) {
            Objects.requireNonNull(accessPolicy, "AccessPolicy must be non null.");
            this.environmentAccess = accessPolicy;
            return this;
        }

        public Builder environment(String name, String value2) {
            Objects.requireNonNull(name, "Name must be non null.");
            Objects.requireNonNull(value2, "Value must be non null.");
            if (this.environment == null) {
                this.environment = new HashMap<String, String>();
            }
            this.environment.put(name, value2);
            return this;
        }

        public Builder environment(Map<String, String> env) {
            Objects.requireNonNull(env, "Env must be non null.");
            for (Map.Entry<String, String> e2 : env.entrySet()) {
                this.environment(e2.getKey(), e2.getValue());
            }
            return this;
        }

        public Builder currentWorkingDirectory(Path workingDirectory) {
            Objects.requireNonNull(workingDirectory, "WorkingDirectory must be non null.");
            if (!workingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("WorkingDirectory must be an absolute path.");
            }
            this.currentWorkingDirectory = workingDirectory;
            return this;
        }

        public Builder hostClassLoader(ClassLoader classLoader) {
            Objects.requireNonNull(classLoader, "ClassLoader must be non null.");
            this.hostClassLoader = classLoader;
            return this;
        }

        public Builder useSystemExit(boolean enabled) {
            this.useSystemExit = enabled;
            return this;
        }

        public Context build() {
            InputStream contextIn;
            OutputStream contextErr;
            OutputStream contextOut;
            Map<String, String> contextOptions;
            IOAccess useIOAccess;
            boolean hostClassLookupEnabled;
            PolyglotAccess polyglotAccess;
            boolean nativeAccess = this.orAllAccess(this.allowNativeAccess);
            boolean createThread = this.orAllAccess(this.allowCreateThread);
            boolean hostClassLoading = this.orAllAccess(this.allowHostClassLoading);
            boolean experimentalOptions = this.orAllAccess(this.allowExperimentalOptions);
            boolean innerContextOptions = this.orAllAccess(this.allowInnerContextOptions);
            if (this.allowHostAccess != null && this.hostAccess != null) {
                throw new IllegalArgumentException("The method Context.Builder.allowHostAccess(boolean) and the method Context.Builder.allowHostAccess(HostAccess) are mutually exclusive.");
            }
            if (this.ioAccess != null && this.allowIO != null) {
                throw new IllegalArgumentException("The method Context.Builder.allowIO(boolean) and the method Context.Builder.allowIO(IOAccess) are mutually exclusive.");
            }
            if (this.ioAccess != null && this.customFileSystem != null) {
                throw new IllegalArgumentException("The method Context.Builder.allowIO(IOAccess) and the method Context.Builder.fileSystem(FileSystem) are mutually exclusive.");
            }
            SandboxPolicy useSandboxPolicy = this.resolveSandboxPolicy();
            this.validateSandbox(useSandboxPolicy);
            Predicate<String> localHostLookupFilter = this.hostClassFilter;
            HostAccess hostAccess = this.hostAccess;
            if (this.allowHostAccess != null && this.allowHostAccess.booleanValue()) {
                if (localHostLookupFilter == UNSET_HOST_LOOKUP) {
                    localHostLookupFilter = ALL_HOST_CLASSES;
                }
                hostAccess = HostAccess.ALL;
            }
            if (hostAccess == null) {
                hostAccess = switch (useSandboxPolicy) {
                    case SandboxPolicy.TRUSTED -> {
                        if (this.allowAllAccess) {
                            yield HostAccess.ALL;
                        }
                        yield HostAccess.EXPLICIT;
                    }
                    case SandboxPolicy.CONSTRAINED -> HostAccess.CONSTRAINED;
                    case SandboxPolicy.ISOLATED -> HostAccess.ISOLATED;
                    case SandboxPolicy.UNTRUSTED -> HostAccess.UNTRUSTED;
                    default -> throw new IllegalArgumentException(String.valueOf((Object)useSandboxPolicy));
                };
            }
            if ((polyglotAccess = this.polyglotAccess) == null) {
                PolyglotAccess polyglotAccess2 = polyglotAccess = this.allowAllAccess ? PolyglotAccess.ALL : PolyglotAccess.NONE;
            }
            if (localHostLookupFilter == UNSET_HOST_LOOKUP) {
                localHostLookupFilter = this.allowAllAccess ? ALL_HOST_CLASSES : null;
            }
            boolean bl = hostClassLookupEnabled = localHostLookupFilter != null;
            if (localHostLookupFilter == null) {
                localHostLookupFilter = NO_HOST_CLASSES;
            }
            boolean createProcess = this.orAllAccess(this.allowCreateProcess);
            EnvironmentAccess useEnvironmentAccess = this.environmentAccess != null ? this.environmentAccess : (this.allowAllAccess ? EnvironmentAccess.INHERIT : EnvironmentAccess.NONE);
            Object limits = this.resourceLimits != null ? this.resourceLimits.receiver : null;
            if (this.ioAccess != null) {
                useIOAccess = this.ioAccess;
            } else if (this.allowIO != null || this.customFileSystem != null) {
                if (this.orAllAccess(this.allowIO)) {
                    useIOAccess = this.customFileSystem != null ? IOAccess.newBuilder().fileSystem(this.customFileSystem).build() : IOAccess.ALL;
                } else {
                    if (this.customFileSystem != null) {
                        throw new IllegalStateException("Cannot install custom FileSystem when IO is disabled.");
                    }
                    useIOAccess = IOAccess.NONE;
                }
            } else {
                useIOAccess = this.allowAllAccess ? IOAccess.ALL : IOAccess.NONE;
            }
            String localCurrentWorkingDirectory = this.currentWorkingDirectory == null ? null : this.currentWorkingDirectory.toString();
            Engine engine = this.sharedEngine;
            if (engine == null) {
                Engine.Builder engineBuilder = Engine.newBuilder(this.permittedLanguages).options(this.options == null ? Collections.emptyMap() : this.options);
                contextOptions = Collections.emptyMap();
                contextOut = null;
                contextErr = null;
                contextIn = null;
                if (this.out != null) {
                    engineBuilder.out(this.out);
                }
                if (this.err != null) {
                    engineBuilder.err(this.err);
                }
                if (this.in != null) {
                    engineBuilder.in(this.in);
                }
                if (this.messageTransport != null) {
                    engineBuilder.serverTransport(this.messageTransport);
                }
                if (this.customLogHandler instanceof Handler) {
                    engineBuilder.logHandler((Handler)this.customLogHandler);
                } else if (this.customLogHandler instanceof OutputStream) {
                    engineBuilder.logHandler((OutputStream)this.customLogHandler);
                }
                engineBuilder.sandbox(useSandboxPolicy);
                engineBuilder.allowExperimentalOptions(experimentalOptions);
                engineBuilder.setBoundEngine(true);
                engine = engineBuilder.build();
            } else {
                if (this.messageTransport != null) {
                    throw new IllegalStateException("Cannot use MessageTransport in a context that shares an Engine.");
                }
                contextOptions = this.options == null ? Collections.emptyMap() : this.options;
                contextOut = this.out;
                contextErr = this.err;
                contextIn = this.in;
            }
            AbstractPolyglotImpl.LogHandler logHandler = this.customLogHandler != null ? Engine.getImpl().newLogHandler(this.customLogHandler) : null;
            Context ctx = engine.dispatch.createContext(engine.receiver, useSandboxPolicy, contextOut, contextErr, contextIn, hostClassLookupEnabled, hostAccess, polyglotAccess, nativeAccess, createThread, hostClassLoading, innerContextOptions, experimentalOptions, localHostLookupFilter, contextOptions, this.arguments == null ? Collections.emptyMap() : this.arguments, this.permittedLanguages, useIOAccess, logHandler, createProcess, this.processHandler, useEnvironmentAccess, this.environment, this.zone, limits, localCurrentWorkingDirectory, this.hostClassLoader, this.allowValueSharing, this.useSystemExit);
            return ctx;
        }

        private boolean orAllAccess(Boolean optionalBoolean) {
            return optionalBoolean != null ? optionalBoolean : this.allowAllAccess;
        }

        private SandboxPolicy resolveSandboxPolicy() {
            SandboxPolicy engineSandboxPolicy;
            SandboxPolicy sandboxPolicy = engineSandboxPolicy = this.sharedEngine != null ? this.sharedEngine.dispatch.getSandboxPolicy(this.sharedEngine.receiver) : null;
            if (this.sandboxPolicy != null && engineSandboxPolicy != null && this.sandboxPolicy != engineSandboxPolicy) {
                throw Engine.Builder.throwSandboxException(this.sandboxPolicy, String.format("The engine and context must have the same SandboxPolicy. The Engine.Builder.sandbox(SandboxPolicy) is set to %s, while the Context.Builder.sandbox(SandboxPolicy) is set to %s.", new Object[]{engineSandboxPolicy, this.sandboxPolicy}), String.format("set Engine.Builder.sandbox(SandboxPolicy) to SandboxPolicy.%s or set Context.Builder.sandbox(SandboxPolicy) to SandboxPolicy.%s", new Object[]{this.sandboxPolicy, engineSandboxPolicy}));
            }
            SandboxPolicy useSandboxPolicy = this.sandboxPolicy != null ? this.sandboxPolicy : (engineSandboxPolicy != null ? engineSandboxPolicy : SandboxPolicy.TRUSTED);
            return useSandboxPolicy;
        }

        private void validateSandbox(SandboxPolicy useSandboxPolicy) {
            if (useSandboxPolicy == SandboxPolicy.TRUSTED) {
                return;
            }
            if (useSandboxPolicy.isStricterOrEqual(SandboxPolicy.CONSTRAINED)) {
                FileSystem fileSystem;
                if (this.permittedLanguages.length == 0 && this.sharedEngine == null) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder does not have a list of permitted languages.", "create a Builder with a list of permitted languages, for example, Context.newBuilder(\"js\")");
                }
                if (this.allowAllAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowAllAccess(boolean) is set to true, but must not be set to true.", "do not set Builder.allowAllAccess(boolean)");
                }
                if (Boolean.TRUE.equals(this.allowNativeAccess)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowNativeAccess(boolean) is set to true, but must not be set to true.", "do not set Builder.allowNativeAccess(boolean)");
                }
                if (Boolean.TRUE.equals(this.allowHostClassLoading)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostClassLoading(boolean) is set to true, but must not be set to true.", "do not set Builder.allowHostClassLoading(boolean)");
                }
                if (Boolean.TRUE.equals(this.allowCreateProcess)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowCreateProcess(boolean) is set to true, but must not be set to true.", "do not set Builder.allowCreateProcess(boolean)");
                }
                if (this.useSystemExit) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.useSystemExit(boolean) is set to true, but must not be set to true.", "do not set Builder.useSystemExit(boolean)");
                }
                if (Engine.isSystemStream(this.in)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder uses the standard input stream, but the input must be redirected.", "do not set Builder.in(InputStream) to use InputStream.nullInputStream() or redirect it to other stream than System.in");
                }
                if (Engine.isSystemStream(this.out)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder uses the standard output stream, but the output must be redirected.", "set Builder.out(OutputStream)");
                }
                if (Engine.isSystemStream(this.err)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder uses the standard error stream, but the error output must be redirected.", "set Builder.err(OutputStream)");
                }
                if (this.ioAccess != null) {
                    AbstractPolyglotImpl.IOAccessor ioAccessor = Engine.getImpl().getIO();
                    if (ioAccessor.hasHostFileAccess(this.ioAccess)) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowIO(IOAccess) is set to an IOAccess, which allows access to the host file system, but access to the host file system must be disabled.", "disable filesystem access using Builder.allowIO(IOAccess.NONE) or install a custom filesystem using Builder.allowIO(IOAccess.newBuilder().fileSystem(customFs))");
                    }
                    if (ioAccessor.hasHostSocketAccess(this.ioAccess)) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowIO(IOAccess) is set to an IOAccess, which allows access to host sockets, but access to host sockets must be disabled.", "do not set IOAccess.Builder.allowHostSocketAccess(boolean)");
                    }
                    assert (this.customFileSystem == null);
                    fileSystem = ioAccessor.getFileSystem(this.ioAccess);
                } else {
                    fileSystem = this.customFileSystem;
                }
                if (fileSystem != null && Engine.getImpl().isHostFileSystem(fileSystem)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowIO(IOAccess) is set to an IOAccess, which has a custom file system that allows access to the host file system, but access to the host file system must be disabled.", "disable filesystem access using Builder.allowIO(IOAccess.NONE) or install a non-host custom filesystem using Builder.allowIO(IOAccess.newBuilder().fileSystem(customFs))");
                }
                if (Boolean.TRUE.equals(this.allowIO)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowIO(boolean) is set to true, but must not be set to true.", "disable filesystem access using Builder.allowIO(IOAccess.NONE) or install a custom filesystem using Builder.allowIO(IOAccess.newBuilder().fileSystem(customFs))");
                }
                if (this.environmentAccess != null && this.environmentAccess != EnvironmentAccess.NONE) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowEnvironmentAccess(EnvironmentAccess) is set to " + this.environmentAccess + ", but must be set to EnvironmentAccess.NONE.", "do not set Builder.allowEnvironmentAccess(EnvironmentAccess) or set it to EnvironmentAccess.NONE");
                }
                if (Boolean.TRUE.equals(this.allowHostAccess)) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(boolean) is set to true, but must not be set to true.", "do not set Builder.allowHostAccess(boolean) to use the sandbox policy preset or set Builder.allowHostAccess(HostAccess)");
                }
                if (this.hostAccess != null) {
                    if (this.hostAccess.allowPublic) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowPublicAccess(boolean) set to true, but HostAccess.Builder.allowPublicAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowPublicAccess(boolean)");
                    }
                    if (this.hostAccess.allowAccessInheritance) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowAccessInheritance(boolean) set to true, but HostAccess.Builder.allowAccessInheritance(boolean) must not be set to true.", "do not set HostAccess.Builder.allowAccessInheritance(boolean)");
                    }
                    if (this.hostAccess.allowAllInterfaceImplementations) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowAllImplementations(boolean) set to true, but HostAccess.Builder.allowAllImplementations(boolean) must not be set to true.", "do not set HostAccess.Builder.allowAllImplementations(boolean)");
                    }
                    if (this.hostAccess.allowAllClassImplementations) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowAllClassImplementations(boolean) set to true, but HostAccess.Builder.allowAllClassImplementations(boolean) must not be set to true.", "do not set HostAccess.Builder.allowAllClassImplementations(boolean)");
                    }
                    if (this.hostAccess.implementableAnnotations != null && this.hostAccess.implementableAnnotations.contains(FunctionalInterface.class)) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which allows FunctionalInterface implementations, but FunctionalInterface implementations must not be enabled.", "do not set HostAccess.Builder.allowImplementationsAnnotatedBy(FunctionalInterface.class)");
                    }
                    HostAccess.MutableTargetMapping[] mutableTargetMappings = this.hostAccess.getMutableTargetMappings();
                    if (mutableTargetMappings.length > 0) {
                        throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which allows host object mappings of mutable target types, but it must not be enabled.", "disable host object mappings of mutable target types by setting HostAccess.Builder.allowMutableTargetMappings(MutableTargetMapping...) to an empty array");
                    }
                }
            }
            if (useSandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED) && this.hostAccess != null && !this.hostAccess.isMethodScopingEnabled()) {
                throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which has no HostAccess.Builder.methodScoping(boolean) set to true, but HostAccess.Builder.methodScoping(boolean) must be enabled.", "set HostAccess.Builder.methodScoping(boolean)");
            }
            if (useSandboxPolicy.isStricterOrEqual(SandboxPolicy.UNTRUSTED) && this.hostAccess != null) {
                if (this.hostAccess.allowArrayAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowArrayAccess(boolean) set to true, but HostAccess.Builder.allowArrayAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowArrayAccess(boolean)");
                }
                if (this.hostAccess.allowListAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowListAccess(boolean) set to true, but HostAccess.Builder.allowListAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowListAccess(boolean)");
                }
                if (this.hostAccess.allowMapAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowMapAccess(boolean) set to true, but HostAccess.Builder.allowMapAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowMapAccess(boolean)");
                }
                if (this.hostAccess.allowBufferAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowBufferAccess(boolean) set to true, but HostAccess.Builder.allowBufferAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowBufferAccess(boolean)");
                }
                if (this.hostAccess.allowIterableAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowIterableAccess(boolean) set to true, but HostAccess.Builder.allowIterableAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowIterableAccess(boolean)");
                }
                if (this.hostAccess.allowIteratorAccess) {
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, "Builder.allowHostAccess(HostAccess) is set to a HostAccess which was created with HostAccess.Builder.allowIteratorAccess(boolean) set to true, but HostAccess.Builder.allowIteratorAccess(boolean) must not be set to true.", "do not set HostAccess.Builder.allowIteratorAccess(boolean)");
                }
                if (this.hostAccess.implementableAnnotations != null && !this.hostAccess.implementableAnnotations.isEmpty()) {
                    List<String> annotations = StreamSupport.stream(this.hostAccess.implementableAnnotations.spliterator(), false).map(Class::getSimpleName).toList();
                    List<String> builderCommands = annotations.stream().map(n -> String.format("HostAccess.Builder.allowImplementationsAnnotatedBy(%s.class)", n)).toList();
                    throw Engine.Builder.throwSandboxException(useSandboxPolicy, String.format("Builder.allowHostAccess(HostAccess) is set to a HostAccess which allows implementations of types annotated by %s, but implementations of annotated types must not be enabled.", String.join((CharSequence)", ", annotations)), String.format("do not set %s", String.join((CharSequence)", ", builderCommands)));
                }
            }
        }
    }
}

