/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml;

import org.pkl.core.util.IoUtils;
import org.pkl.core.util.yaml.YamlEmitter;

public final class Yaml11Emitter
extends YamlEmitter {
    public Yaml11Emitter(StringBuilder builder, String indent) {
        super(builder, indent);
    }

    @Override
    protected boolean isReservedWord(String str) {
        return Yaml11Emitter.isReserved11Word(str);
    }

    @Override
    protected boolean isNumber(String str, int colonIndex) {
        int offset;
        int length2 = str.length();
        assert (length2 > 0);
        if (length2 == 1) {
            char ch = str.charAt(0);
            return IoUtils.isDecimalDigit(ch) || ch == '.';
        }
        switch (str.charAt(0)) {
            case '+': 
            case '-': {
                int n = 1;
                break;
            }
            default: {
                int n = offset = 0;
            }
        }
        if (colonIndex != -1) {
            return Yaml11Emitter.isSexagesimalNumber(str, offset, length2, colonIndex);
        }
        switch (str.charAt(offset)) {
            case 'o': {
                return Yaml11Emitter.isOctalNumber(str, offset + 1, length2);
            }
            case '0': {
                if (offset == length2 - 1) {
                    return true;
                }
                switch (str.charAt(offset + 1)) {
                    case 'b': {
                        return Yaml11Emitter.isBinaryNumber(str, offset + 2, length2);
                    }
                    case 'x': {
                        return Yaml11Emitter.isHexadecimalNumber(str, offset + 2, length2);
                    }
                }
            }
        }
        return Yaml11Emitter.isDecimalNumber(str, offset, length2);
    }

    static boolean isBinaryNumber(String str, int start2, int length2) {
        if (start2 == length2) {
            return false;
        }
        for (int i = start2; i < length2; ++i) {
            char ch = str.charAt(i);
            if (IoUtils.isBinaryDigitOrUnderscore(ch)) continue;
            return false;
        }
        return true;
    }

    static boolean isOctalNumber(String str, int start2, int length2) {
        if (start2 == length2) {
            return false;
        }
        for (int i = start2; i < length2; ++i) {
            char ch = str.charAt(i);
            if (IoUtils.isOctalDigitOrUnderscore(ch)) continue;
            return false;
        }
        return true;
    }

    static boolean isDecimalNumber(String str, int start2, int length2) {
        int index;
        char ch = '\u0000';
        for (index = start2; index < length2 && IoUtils.isDecimalDigitOrUnderscore(ch = str.charAt(index)); ++index) {
        }
        if (index == length2) {
            return true;
        }
        if (ch != '.') {
            return false;
        }
        ++index;
        while (index < length2 && IoUtils.isDecimalDigitOrUnderscore(ch = str.charAt(index))) {
            ++index;
        }
        if (index == length2) {
            return true;
        }
        if (ch != 'e' && ch != 'E') {
            return false;
        }
        if (++index + 1 >= length2) {
            return false;
        }
        ch = str.charAt(index);
        if (ch != '-' && ch != '+') {
            return false;
        }
        ++index;
        while (index < length2 && IoUtils.isDecimalDigit(ch = str.charAt(index))) {
            ++index;
        }
        return index == length2;
    }

    static boolean isHexadecimalNumber(String str, int start2, int length2) {
        if (start2 == length2) {
            return false;
        }
        for (int i = start2; i < length2; ++i) {
            char ch = str.charAt(i);
            if (IoUtils.isHexDigitOrUnderscore(ch)) continue;
            return false;
        }
        return true;
    }

    static boolean isSexagesimalNumber(String str, int start2, int length2, int colonIndex) {
        if (!IoUtils.isNonZeroDecimalDigit(str.charAt(start2))) {
            return false;
        }
        for (int i = start2 + 1; i < colonIndex; ++i) {
            if (IoUtils.isDecimalDigitOrUnderscore(str.charAt(i))) continue;
            return false;
        }
        int state = 1;
        block20: for (int i = colonIndex + 1; i < length2; ++i) {
            switch (state) {
                case 0: {
                    switch (str.charAt(i)) {
                        case ':': {
                            state = 1;
                            continue block20;
                        }
                        case '.': {
                            state = 3;
                            continue block20;
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (str.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': {
                            state = 2;
                            continue block20;
                        }
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            state = 0;
                            continue block20;
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (str.charAt(i)) {
                        case ':': {
                            state = 1;
                            continue block20;
                        }
                        case '.': {
                            state = 3;
                            continue block20;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            state = 0;
                            continue block20;
                        }
                    }
                    return false;
                }
                case 3: {
                    for (int j = i; j < length2; ++j) {
                        if (IoUtils.isDecimalDigitOrUnderscore(str.charAt(j))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return state != 1;
    }
}

