/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.registry;

import java.util.HashMap;
import java.util.Map;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.primary.GetReceiverNode;
import org.pkl.core.ast.frame.ReadFrameSlotNode;
import org.pkl.core.ast.frame.ReadFrameSlotNodeGen;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalMethod3Node;
import org.pkl.core.stdlib.ExternalMethod4Node;
import org.pkl.core.stdlib.ExternalMethod5Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class ExternalMemberRegistry {
    private final Map<String, ExternalPropertyNode.Factory> propertyFactories = new HashMap<String, ExternalPropertyNode.Factory>();
    private final Map<String, ExternalMethod0Node.Factory> function0Factories = new HashMap<String, ExternalMethod0Node.Factory>();
    private final Map<String, ExternalMethod1Node.Factory> function1Factories = new HashMap<String, ExternalMethod1Node.Factory>();
    private final Map<String, ExternalMethod2Node.Factory> function2Factories = new HashMap<String, ExternalMethod2Node.Factory>();
    private final Map<String, ExternalMethod3Node.Factory> function3Factories = new HashMap<String, ExternalMethod3Node.Factory>();
    private final Map<String, ExternalMethod4Node.Factory> function4Factories = new HashMap<String, ExternalMethod4Node.Factory>();
    private final Map<String, ExternalMethod5Node.Factory> function5Factories = new HashMap<String, ExternalMethod5Node.Factory>();

    public final ExpressionNode getPropertyBody(String qualifiedName, SourceSection headerSection) {
        ExternalPropertyNode.Factory factory = this.propertyFactories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        return factory.create(new GetReceiverNode());
    }

    public final ExpressionNode getFunctionBody(String qualifiedName, SourceSection headerSection, int paramCount) {
        return switch (paramCount) {
            case 0 -> this.getFunction0Body(qualifiedName, headerSection);
            case 1 -> this.getFunction1Body(qualifiedName, headerSection);
            case 2 -> this.getFunction2Body(qualifiedName, headerSection);
            case 3 -> this.getFunction3Body(qualifiedName, headerSection);
            case 4 -> this.getFunction4Body(qualifiedName, headerSection);
            case 5 -> this.getFunction5Body(qualifiedName, headerSection);
            default -> throw new IllegalStateException("External methods with more than 5 parameters are not currently supported.");
        };
    }

    protected void register(String memberName, ExternalPropertyNode.Factory factory) {
        if (this.propertyFactories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod0Node.Factory factory) {
        if (this.function0Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod1Node.Factory factory) {
        if (this.function1Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod2Node.Factory factory) {
        if (this.function2Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod3Node.Factory factory) {
        if (this.function3Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod4Node.Factory factory) {
        if (this.function4Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    protected void register(String memberName, ExternalMethod5Node.Factory factory) {
        if (this.function5Factories.put(memberName, factory) != null) {
            throw this.duplicateRegistration(memberName);
        }
    }

    private ExpressionNode getFunction0Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod0Node.Factory factory = this.function0Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        return factory.create(new GetReceiverNode());
    }

    private ExpressionNode getFunction1Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod1Node.Factory factory = this.function1Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        SourceSection sourceSection = VmUtils.unavailableSourceSection();
        ReadFrameSlotNode param1Node = ReadFrameSlotNodeGen.create(sourceSection, 0);
        return factory.create(new GetReceiverNode(), param1Node);
    }

    private ExpressionNode getFunction2Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod2Node.Factory factory = this.function2Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        SourceSection sourceSection = VmUtils.unavailableSourceSection();
        ReadFrameSlotNode param1Node = ReadFrameSlotNodeGen.create(sourceSection, 0);
        ReadFrameSlotNode param2Node = ReadFrameSlotNodeGen.create(sourceSection, 1);
        return factory.create(new GetReceiverNode(), param1Node, param2Node);
    }

    private ExpressionNode getFunction3Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod3Node.Factory factory = this.function3Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        SourceSection sourceSection = VmUtils.unavailableSourceSection();
        ReadFrameSlotNode param1Node = ReadFrameSlotNodeGen.create(sourceSection, 0);
        ReadFrameSlotNode param2Node = ReadFrameSlotNodeGen.create(sourceSection, 1);
        ReadFrameSlotNode param3Node = ReadFrameSlotNodeGen.create(sourceSection, 2);
        return factory.create(new GetReceiverNode(), param1Node, param2Node, param3Node);
    }

    private ExpressionNode getFunction4Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod4Node.Factory factory = this.function4Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        SourceSection sourceSection = VmUtils.unavailableSourceSection();
        ReadFrameSlotNode param1Node = ReadFrameSlotNodeGen.create(sourceSection, 0);
        ReadFrameSlotNode param2Node = ReadFrameSlotNodeGen.create(sourceSection, 1);
        ReadFrameSlotNode param3Node = ReadFrameSlotNodeGen.create(sourceSection, 2);
        ReadFrameSlotNode param4Node = ReadFrameSlotNodeGen.create(sourceSection, 3);
        return factory.create(new GetReceiverNode(), param1Node, param2Node, param3Node, param4Node);
    }

    private ExpressionNode getFunction5Body(String qualifiedName, SourceSection headerSection) {
        ExternalMethod5Node.Factory factory = this.function5Factories.get(qualifiedName);
        if (factory == null) {
            throw this.cannotFindMemberImpl(qualifiedName, headerSection);
        }
        SourceSection sourceSection = VmUtils.unavailableSourceSection();
        ReadFrameSlotNode param1Node = ReadFrameSlotNodeGen.create(sourceSection, 0);
        ReadFrameSlotNode param2Node = ReadFrameSlotNodeGen.create(sourceSection, 1);
        ReadFrameSlotNode param3Node = ReadFrameSlotNodeGen.create(sourceSection, 2);
        ReadFrameSlotNode param4Node = ReadFrameSlotNodeGen.create(sourceSection, 3);
        ReadFrameSlotNode param5Node = ReadFrameSlotNodeGen.create(sourceSection, 4);
        return factory.create(new GetReceiverNode(), param1Node, param2Node, param3Node, param4Node, param5Node);
    }

    private VmException duplicateRegistration(String memberName) {
        return new VmExceptionBuilder().bug("Duplicate registration of external member `%s`.", memberName).build();
    }

    private VmException cannotFindMemberImpl(String qualifiedName, SourceSection headerSection) {
        return new VmExceptionBuilder().bug("Cannot find implementation of external member `%s`.", qualifiedName).withSourceSection(headerSection).withMemberName(qualifiedName).build();
    }
}

