/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.ArrayCharEscaper;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class PListRendererNodes {
    private PListRendererNodes() {
    }

    private static PListRenderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmUtils.readMember(self, Identifier.INDENT);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter converter = new PklConverter(converters);
        return new PListRenderer(builder, indent, converter);
    }

    private static final class PListRenderer
    extends AbstractRenderer {
        private static final ArrayCharEscaper charEscaper = ArrayCharEscaper.builder().withEscape('\"', "&quot;").withEscape('\'', "&apos;").withEscape('<', "&lt;").withEscape('>', "&gt;").withEscape('&', "&amp;").build();

        public PListRenderer(StringBuilder builder, String indent, PklConverter converter) {
            super("XML property list", builder, indent, converter, true, true);
        }

        @Override
        public void visitString(String value2) {
            this.builder.append("<string>").append(charEscaper.escape(value2)).append("</string>");
        }

        @Override
        public void visitInt(Long value2) {
            this.builder.append("<integer>").append(value2).append("</integer>");
        }

        @Override
        public void visitFloat(Double value2) {
            this.builder.append("<real>");
            if (value2.isNaN()) {
                this.builder.append("nan");
            } else if (value2 == Double.POSITIVE_INFINITY) {
                this.builder.append("+infinity");
            } else if (value2 == Double.NEGATIVE_INFINITY) {
                this.builder.append("-infinity");
            } else {
                this.builder.append(value2);
            }
            this.builder.append("</real>");
        }

        @Override
        public void visitBoolean(Boolean value2) {
            if (value2.booleanValue()) {
                this.builder.append("<true/>");
            } else {
                this.builder.append("<false/>");
            }
        }

        @Override
        public void visitDuration(VmDuration value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderType", "Duration", "XML property list").withProgramValue("Value", value2).build();
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderType", "DataSize", "XML property list").withProgramValue("Value", value2).build();
        }

        @Override
        public void visitRegex(VmRegex value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderType", "Regex", "XML property list").withProgramValue("Value", value2).build();
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderType", "IntSeq", "XML property list").withProgramValue("Value", value2).build();
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void visitDocument(Object value2) {
            if (!(value2 instanceof VmCollection || value2 instanceof VmMap || value2 instanceof VmObjectLike)) {
                throw new VmExceptionBuilder().evalError("invalidPListTopLevelValue", VmUtils.getClass(value2)).withProgramValue("Value", value2).build();
            }
            this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n').append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">").append('\n').append("<plist version=\"1.0\">").append('\n');
            this.visit(value2);
            this.builder.append('\n').append("</plist>").append('\n');
        }

        @Override
        protected void visitTopLevelValue(Object value2) {
            this.visit(value2);
        }

        @Override
        protected void visitRenderDirective(VmTyped value2) {
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
            this.increaseIndent();
        }

        @Override
        protected void startTyped(VmTyped value2) {
            this.increaseIndent();
        }

        @Override
        protected void startListing(VmListing value2) {
            this.increaseIndent();
        }

        @Override
        protected void startMapping(VmMapping value2) {
            this.increaseIndent();
        }

        @Override
        protected void startList(VmList value2) {
            this.increaseIndent();
        }

        @Override
        protected void startSet(VmSet value2) {
            this.increaseIndent();
        }

        @Override
        protected void startMap(VmMap value2) {
            this.increaseIndent();
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            if (isFirst) {
                this.builder.append("<array>").append('\n');
            }
            this.builder.append((CharSequence)this.currIndent);
            this.visit(value2);
            this.builder.append('\n');
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            if (isFirst) {
                this.builder.append("<dict>").append('\n');
            }
            if (VmUtils.isRenderDirective(key2)) {
                key2 = VmUtils.readTextProperty(key2);
            }
            if (key2 instanceof String) {
                String string = (String)key2;
                this.builder.append((CharSequence)this.currIndent).append("<key>").append(charEscaper.escape(string)).append("</key>").append('\n').append((CharSequence)this.currIndent);
                return;
            }
            this.cannotRenderNonStringKey(key2);
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.visit(value2);
            this.builder.append('\n');
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            if (isFirst) {
                this.builder.append("<dict>").append('\n');
            }
            this.builder.append((CharSequence)this.currIndent).append("<key>").append(charEscaper.escape(name.toString())).append("</key>").append('\n').append((CharSequence)this.currIndent);
            this.visit(value2);
            this.builder.append('\n');
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
            if (value2.hasElements()) {
                this.endArray(isEmpty2);
            } else {
                this.endDict(isEmpty2);
            }
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
            this.endDict(isEmpty2);
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
            this.endArray(isEmpty2);
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
            this.endDict(isEmpty2);
        }

        @Override
        protected void endList(VmList value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endSet(VmSet value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endMap(VmMap value2) {
            this.endDict(value2.isEmpty());
        }

        private void endDict(boolean isEmpty2) {
            this.decreaseIndent();
            this.builder.append((CharSequence)this.currIndent);
            if (isEmpty2) {
                this.builder.append("<dict/>");
            } else {
                this.builder.append("</dict>");
            }
        }

        private void endArray(boolean isEmpty2) {
            this.decreaseIndent();
            this.builder.append((CharSequence)this.currIndent);
            if (isEmpty2) {
                this.builder.append("<array/>");
            } else {
                this.builder.append("</array>");
            }
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PListRendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PListRendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

