/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.util.Map;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction3Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3NodeGen;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.MutableReference;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class MapNodes {
    private MapNodes() {
    }

    public static abstract class toMapping
    extends ExternalMethod0Node {
        @Specialization
        protected VmMapping eval(VmMap self) {
            return self.toMapping();
        }
    }

    public static abstract class toTyped
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmMap self, VmClass clazz) {
            if (!clazz.isSubclassOf(BaseModule.getTypedClass())) {
                throw this.exceptionBuilder().evalError("notASubclassOfTyped", clazz).build();
            }
            VmUtils.checkIsInstantiable(clazz, null);
            VmTyped result = new VmTyped(VmUtils.createEmptyMaterializedFrame(), clazz.getPrototype(), clazz, clazz.getMapToTypedMembers());
            result.setExtraStorage(self);
            return result;
        }
    }

    public static abstract class toDynamic
    extends ExternalMethod0Node {
        @Specialization
        protected VmDynamic eval(VmMap self) {
            return self.toDynamic();
        }
    }

    public static abstract class toMap
    extends ExternalMethod0Node {
        @Specialization
        protected VmMap eval(VmMap self) {
            return self;
        }
    }

    public static abstract class any
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected boolean eval(VmMap self, VmFunction function) {
            for (Map.Entry<Object, Object> entry : self) {
                if (!this.applyLambdaNode.executeBoolean(function, VmUtils.getKey(entry), VmUtils.getValue(entry))) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class every
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected boolean eval(VmMap self, VmFunction function) {
            for (Map.Entry<Object, Object> entry : self) {
                if (this.applyLambdaNode.executeBoolean(function, VmUtils.getKey(entry), VmUtils.getValue(entry))) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class flatMap
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmMap eval(VmMap self, VmFunction function) {
            VmMap.Builder builder = VmMap.builder();
            for (Map.Entry<Object, Object> entry : self) {
                VmMap flatMapResult = this.applyLambdaNode.executeMap(function, VmUtils.getKey(entry), VmUtils.getValue(entry));
                for (Map.Entry<Object, Object> flatMapEntry : flatMapResult) {
                    builder.add(VmUtils.getKey(flatMapEntry), VmUtils.getValue(flatMapEntry));
                }
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class mapValues
    extends ExternalMethod1Node {
        @Specialization
        protected VmMap eval(VmMap self, VmFunction function, @Cached(value="create()") ApplyVmFunction2Node applyNode) {
            VmMap.Builder builder = VmMap.builder();
            for (Map.Entry<Object, Object> entry : self) {
                builder.add(VmUtils.getKey(entry), applyNode.execute(function, VmUtils.getKey(entry), VmUtils.getValue(entry)));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class mapKeys
    extends ExternalMethod1Node {
        @Specialization
        protected VmMap eval(VmMap self, VmFunction function, @Cached(value="create()") ApplyVmFunction2Node applyNode) {
            VmMap.Builder builder = VmMap.builder();
            for (Map.Entry<Object, Object> entry : self) {
                builder.add(applyNode.execute(function, VmUtils.getKey(entry), VmUtils.getValue(entry)), VmUtils.getValue(entry));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class map
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmMap eval(VmMap self, VmFunction function) {
            VmMap.Builder builder = VmMap.builder();
            for (Map.Entry<Object, Object> entry : self) {
                VmPair pair = this.applyLambdaNode.executePair(function, VmUtils.getKey(entry), VmUtils.getValue(entry));
                builder.add(pair.getFirst(), pair.getSecond());
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction3Node applyLambdaNode = ApplyVmFunction3NodeGen.create();

        @Specialization
        protected Object eval(VmMap self, Object initial, VmFunction function) {
            MutableReference<Object> result = new MutableReference<Object>(initial);
            for (Map.Entry<Object, Object> entry : self) {
                result.set(this.applyLambdaNode.execute(function, result.get(), VmUtils.getKey(entry), VmUtils.getValue(entry)));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result.get();
        }
    }

    public static abstract class filter
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmMap eval(VmMap self, VmFunction function) {
            VmMap.Builder builder = VmMap.builder();
            for (Map.Entry<Object, Object> entry : self) {
                Object value2;
                Object key2 = VmUtils.getKey(entry);
                if (!this.applyLambdaNode.executeBoolean(function, key2, value2 = VmUtils.getValue(entry))) continue;
                builder.add(key2, value2);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class remove
    extends ExternalMethod1Node {
        @Specialization
        protected VmMap eval(VmMap self, Object key2) {
            return self.remove(key2);
        }
    }

    public static abstract class put
    extends ExternalMethod2Node {
        @Specialization
        protected VmMap eval(VmMap self, Object key2, Object value2) {
            return self.put(key2, value2);
        }
    }

    public static abstract class containsValue
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmMap self, Object value2) {
            return self.containsValue(value2);
        }
    }

    public static abstract class containsKey
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmMap self, Object key2) {
            return self.containsKey(key2);
        }
    }

    public static abstract class entries
    extends ExternalPropertyNode {
        @Specialization
        protected VmList eval(VmMap self) {
            return self.entries();
        }
    }

    public static abstract class values
    extends ExternalPropertyNode {
        @Specialization
        protected VmList eval(VmMap self) {
            return self.values();
        }
    }

    public static abstract class keys
    extends ExternalPropertyNode {
        @Specialization
        protected VmSet eval(VmMap self) {
            return self.keys();
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmMap self) {
            return self.isEmpty();
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmMap self) {
            return self.getLength();
        }
    }

    public static abstract class getOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmMap self, Object key2) {
            return self.getOrVmNull(key2);
        }
    }
}

