/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.pkl.core.ValueFormatter;
import org.pkl.core.parser.Lexer;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.MutableBoolean;

public final class VmValueRenderer {
    private final int lengthLimit;
    private final String leadingOrTrailingNewline;
    private final String interiorNewline;
    private final String indent;
    private String currIndent = "";

    public static VmValueRenderer singleLine(int lengthLimit) {
        return new VmValueRenderer(lengthLimit, " ", "; ", "");
    }

    public static VmValueRenderer multiLine(int lengthLimit) {
        return new VmValueRenderer(lengthLimit, "\n", "\n", "  ");
    }

    private VmValueRenderer(int lengthLimit, String leadingOrTrailingNewline, String interiorNewline, String indent) {
        this.lengthLimit = lengthLimit;
        this.leadingOrTrailingNewline = leadingOrTrailingNewline;
        this.interiorNewline = interiorNewline;
        this.indent = indent;
    }

    public String render(Object value2) {
        StringBuilder builder = new StringBuilder();
        this.render(value2, builder);
        return builder.toString();
    }

    private void render(Object value2, StringBuilder builder) {
        try {
            new Visitor(builder).visit(value2);
        }
        catch (LengthLimitReached lengthLimitReached) {
            // empty catch block
        }
    }

    private class Visitor
    implements VmValueVisitor {
        private final StringBuilder builder;
        private final int initialLength;
        private final ValueFormatter valueFormatter;
        private final Deque<Context> contexts = new ArrayDeque<Context>();

        private Visitor(StringBuilder builder) {
            this.builder = builder;
            this.valueFormatter = ValueFormatter.basic();
            this.initialLength = builder.length();
            this.contexts.push(Context.EXPLICIT);
        }

        @Override
        public void visitString(String value2) {
            this.valueFormatter.formatStringValue(value2, (CharSequence)"", this.builder);
            this.checkLengthLimit();
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.append(value2);
        }

        @Override
        public void visitInt(Long value2) {
            this.append(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            this.append(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.append(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.append(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.append("Pair(");
            this.visit(value2.getFirst());
            this.append(", ");
            this.visit(value2.getSecond());
            this.append(Character.valueOf(')'));
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.append(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.append(value2);
        }

        @Override
        public void visitList(VmList value2) {
            this.doVisitCollection(value2, "List(");
        }

        @Override
        public void visitSet(VmSet value2) {
            this.doVisitCollection(value2, "Set(");
        }

        @Override
        public void visitMap(VmMap value2) {
            this.contexts.push(Context.EXPLICIT);
            this.append("Map(");
            boolean isFirst = true;
            for (Map.Entry<Object, Object> entry : value2) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.append(", ");
                }
                this.visit(entry.getKey());
                this.append(", ");
                this.visit(entry.getValue());
            }
            this.append(Character.valueOf(')'));
            this.contexts.pop();
        }

        @Override
        public void visitDynamic(VmDynamic value2) {
            Context context = this.contexts.peek();
            if (context == Context.EXPLICIT) {
                this.append("new Dynamic ");
            }
            this.doVisitObject(value2);
        }

        @Override
        public void visitTyped(VmTyped value2) {
            this.writeClassName(value2);
            this.doVisitObject(value2);
        }

        @Override
        public void visitListing(VmListing value2) {
            Context context = this.contexts.peek();
            if (context == Context.EXPLICIT) {
                this.append("new Listing ");
            }
            this.doVisitObject(value2);
        }

        @Override
        public void visitMapping(VmMapping value2) {
            Context context = this.contexts.peek();
            if (context == Context.EXPLICIT) {
                this.append("new Mapping ");
            }
            this.doVisitObject(value2);
        }

        @Override
        public void visitFunction(VmFunction value2) {
            this.writeClassName(value2);
            this.append("{}");
        }

        @Override
        public void visitClass(VmClass value2) {
            this.append(value2);
        }

        @Override
        public void visitTypeAlias(VmTypeAlias value2) {
            this.append(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            this.append("null");
        }

        private void append(Object value2) {
            this.builder.append(value2);
            this.checkLengthLimit();
        }

        private void checkLengthLimit() {
            if (this.builder.length() - this.initialLength < VmValueRenderer.this.lengthLimit) {
                return;
            }
            this.builder.delete(VmValueRenderer.this.lengthLimit - 3, this.builder.length());
            this.builder.append("...");
            throw new LengthLimitReached();
        }

        private void doVisitCollection(VmCollection collection, String prefix) {
            this.contexts.push(Context.EXPLICIT);
            this.append(prefix);
            boolean isFirst = true;
            for (Object elem : collection) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.append(", ");
                }
                this.visit(elem);
            }
            this.append(Character.valueOf(')'));
            this.contexts.pop();
        }

        private void doVisitObject(VmObjectLike object) {
            this.append(Character.valueOf('{'));
            int lengthAfterOpeningDelimiter = this.builder.length();
            VmValueRenderer.this.currIndent = VmValueRenderer.this.currIndent + VmValueRenderer.this.indent;
            MutableBoolean isEmpty2 = new MutableBoolean(true);
            object.iterateMemberValues((key2, member, value2) -> {
                if (member.isClass() || member.isTypeAlias()) {
                    return true;
                }
                if (isEmpty2.get()) {
                    this.append(VmValueRenderer.this.leadingOrTrailingNewline);
                    isEmpty2.set(false);
                }
                this.append(VmValueRenderer.this.currIndent);
                if (member.isProp()) {
                    this.contexts.push(Context.IMPLICIT);
                    this.writeIdentifier(key2.toString());
                    if (value2 instanceof VmObjectLike) {
                        this.append(Character.valueOf(' '));
                    } else {
                        this.append(" = ");
                    }
                } else if (member.isElement()) {
                    this.contexts.push(Context.EXPLICIT);
                } else {
                    assert (member.isEntry());
                    this.contexts.push(Context.EXPLICIT);
                    this.append(Character.valueOf('['));
                    this.visit(key2);
                    this.append(Character.valueOf(']'));
                    this.contexts.pop();
                    this.contexts.push(Context.IMPLICIT);
                    if (value2 instanceof VmObjectLike) {
                        this.append(Character.valueOf(' '));
                    } else {
                        this.append(" = ");
                    }
                }
                if (value2 == null) {
                    this.append(Character.valueOf('?'));
                } else {
                    this.visit(value2);
                }
                this.contexts.pop();
                this.append(VmValueRenderer.this.interiorNewline);
                return true;
            });
            if (!isEmpty2.get()) {
                this.builder.delete(this.builder.length() - VmValueRenderer.this.interiorNewline.length(), this.builder.length());
                this.append(VmValueRenderer.this.leadingOrTrailingNewline);
            }
            VmValueRenderer.this.currIndent = VmValueRenderer.this.currIndent.substring(0, VmValueRenderer.this.currIndent.length() - VmValueRenderer.this.indent.length());
            if (this.builder.length() > lengthAfterOpeningDelimiter) {
                this.append(VmValueRenderer.this.currIndent);
            }
            this.append(Character.valueOf('}'));
        }

        private void writeClassName(VmValue value2) {
            Context context = this.contexts.peek();
            if (context == Context.IMPLICIT) {
                return;
            }
            VmClass clazz = value2.getVmClass();
            this.append("new ");
            this.append(clazz.getSimpleName());
            this.append(Character.valueOf(' '));
        }

        private void writeIdentifier(String identifier) {
            if (Lexer.isRegularIdentifier(identifier)) {
                this.append(identifier);
            } else {
                this.append(Character.valueOf('`'));
                this.append(identifier);
                this.append(Character.valueOf('`'));
            }
        }
    }

    private static final class LengthLimitReached
    extends RuntimeException {
        private LengthLimitReached() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static enum Context {
        EXPLICIT,
        IMPLICIT;

    }
}

