/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValue;

public interface VmValueConverter<T> {
    public static final Object WILDCARD_PROPERTY = new Object(){

        public String toString() {
            return "WILDCARD_PROPERTY";
        }
    };
    public static final Object WILDCARD_ELEMENT = new Object(){

        public String toString() {
            return "WILDCARD_ELEMENT";
        }
    };
    public static final Object TOP_LEVEL_VALUE = new Object(){

        public String toString() {
            return "TOP_LEVEL_VALUE";
        }
    };

    public T convertString(String var1, Iterable<Object> var2);

    public T convertBoolean(Boolean var1, Iterable<Object> var2);

    public T convertInt(Long var1, Iterable<Object> var2);

    public T convertFloat(Double var1, Iterable<Object> var2);

    public T convertDuration(VmDuration var1, Iterable<Object> var2);

    public T convertDataSize(VmDataSize var1, Iterable<Object> var2);

    public T convertIntSeq(VmIntSeq var1, Iterable<Object> var2);

    public T convertList(VmList var1, Iterable<Object> var2);

    public T convertSet(VmSet var1, Iterable<Object> var2);

    public T convertMap(VmMap var1, Iterable<Object> var2);

    public T convertTyped(VmTyped var1, Iterable<Object> var2);

    public T convertDynamic(VmDynamic var1, Iterable<Object> var2);

    public T convertListing(VmListing var1, Iterable<Object> var2);

    public T convertMapping(VmMapping var1, Iterable<Object> var2);

    public T convertClass(VmClass var1, Iterable<Object> var2);

    public T convertTypeAlias(VmTypeAlias var1, Iterable<Object> var2);

    public T convertNull(VmNull var1, Iterable<Object> var2);

    public T convertPair(VmPair var1, Iterable<Object> var2);

    public T convertRegex(VmRegex var1, Iterable<Object> var2);

    public T convertFunction(VmFunction var1, Iterable<Object> var2);

    default public T convert(Object value2, Iterable<Object> path) {
        if (value2 instanceof VmValue) {
            VmValue vmValue = (VmValue)value2;
            return vmValue.accept(this, path);
        }
        if (value2 instanceof String) {
            String string = (String)value2;
            return this.convertString(string, path);
        }
        if (value2 instanceof Boolean) {
            Boolean b2 = (Boolean)value2;
            return this.convertBoolean(b2, path);
        }
        if (value2 instanceof Long) {
            Long l = (Long)value2;
            return this.convertInt(l, path);
        }
        if (value2 instanceof Double) {
            Double d2 = (Double)value2;
            return this.convertFloat(d2, path);
        }
        throw new IllegalArgumentException("Cannot convert VM value with unexpected type: " + value2);
    }
}

