/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUndefinedValueException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;

public abstract class VmObject
extends VmObjectLike {
    @CompilerDirectives.CompilationFinal
    @Nullable
    protected VmObject parent;
    protected final UnmodifiableEconomicMap<Object, ObjectMember> members;
    protected final EconomicMap<Object, Object> cachedValues;
    protected int cachedHash;
    private boolean forced;

    public VmObject(MaterializedFrame enclosingFrame, @Nullable VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members, EconomicMap<Object, Object> cachedValues) {
        super(enclosingFrame);
        this.parent = parent;
        this.members = members;
        this.cachedValues = cachedValues;
        assert (parent != this);
    }

    public VmObject(MaterializedFrame enclosingFrame, @Nullable VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members) {
        this(enclosingFrame, parent, members, EconomicMaps.create());
    }

    public final void lateInitParent(VmObject parent) {
        assert (this.parent == null);
        this.parent = parent;
    }

    @Override
    @Nullable
    public VmObject getParent() {
        return this.parent;
    }

    @Override
    public final boolean hasMember(Object key2) {
        return EconomicMaps.containsKey(this.members, key2);
    }

    @Override
    @Nullable
    public final ObjectMember getMember(Object key2) {
        return EconomicMaps.get(this.members, key2);
    }

    @Override
    public final UnmodifiableEconomicMap<Object, ObjectMember> getMembers() {
        return this.members;
    }

    @Override
    @Nullable
    public final Object getCachedValue(Object key2) {
        return EconomicMaps.get(this.cachedValues, key2);
    }

    @Override
    public final void setCachedValue(Object key2, Object value2) {
        EconomicMaps.put(this.cachedValues, key2, value2);
    }

    @Override
    public final boolean hasCachedValue(Object key2) {
        return EconomicMaps.containsKey(this.cachedValues, key2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean iterateMemberValues(VmObjectLike.MemberValueConsumer consumer) {
        HashSet visited = new HashSet();
        return this.iterateMembers((key2, member) -> {
            boolean alreadyVisited;
            boolean bl = alreadyVisited = !visited.add(key2);
            if (alreadyVisited || member.isLocalOrExternalOrHidden()) {
                return true;
            }
            return consumer.accept(key2, (ObjectMember)member, this.getCachedValue(key2));
        });
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean forceAndIterateMemberValues(VmObjectLike.ForcedMemberValueConsumer consumer) {
        this.force(false, false);
        return this.iterateAlreadyForcedMemberValues(consumer);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean iterateAlreadyForcedMemberValues(VmObjectLike.ForcedMemberValueConsumer consumer) {
        HashSet visited = new HashSet();
        return this.iterateMembers((key2, member) -> {
            boolean alreadyVisited;
            boolean bl = alreadyVisited = !visited.add(key2);
            if (alreadyVisited || member.isLocalOrExternalOrHidden()) {
                return true;
            }
            Object cachedValue = this.getCachedValue(key2);
            assert (cachedValue != null);
            return consumer.accept(key2, (ObjectMember)member, cachedValue);
        });
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean iterateMembers(BiFunction<Object, ObjectMember, Boolean> consumer) {
        boolean completed;
        VmObject parent = this.getParent();
        if (parent != null && !(completed = parent.iterateMembers(consumer))) {
            return false;
        }
        UnmodifiableMapCursor<Object, ObjectMember> entries2 = this.members.getEntries();
        while (entries2.advance()) {
            ObjectMember member = entries2.getValue();
            if (member.isLocal() || consumer.apply(entries2.getKey(), member).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final void force(boolean allowUndefinedValues, boolean recurse) {
        if (this.forced) {
            return;
        }
        if (recurse) {
            this.forced = true;
        }
        try {
            for (VmObjectLike owner = this; owner != null; owner = ((VmObjectLike)owner).getParent()) {
                UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(((VmObjectLike)owner).getMembers());
                VmClass clazz = owner.getVmClass();
                while (cursor.advance()) {
                    Object memberKey = cursor.getKey();
                    ObjectMember member = cursor.getValue();
                    if (member.isLocalOrExternalOrAbstract() || clazz.isHiddenProperty(memberKey)) continue;
                    Object memberValue = this.getCachedValue(memberKey);
                    if (memberValue == null) {
                        try {
                            memberValue = VmUtils.doReadMember(this, owner, memberKey, member);
                        }
                        catch (VmUndefinedValueException e2) {
                            if (allowUndefinedValues) continue;
                            throw e2;
                        }
                    }
                    if (!recurse) continue;
                    VmValue.force(memberValue, allowUndefinedValues);
                }
            }
        }
        catch (Throwable t) {
            this.forced = false;
            throw t;
        }
    }

    @Override
    public final void force(boolean allowUndefinedValues) {
        this.force(allowUndefinedValues, true);
    }

    public final String toString() {
        this.force(true, true);
        return VmValueRenderer.singleLine(Integer.MAX_VALUE).render(this);
    }

    @CompilerDirectives.TruffleBoundary
    protected final Map<String, Object> exportMembers() {
        LinkedHashMap<String, Object> result = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.cachedValues));
        this.iterateMemberValues((key2, member, value2) -> {
            if (member.isClass() || member.isTypeAlias()) {
                return true;
            }
            result.put(key2.toString(), VmValue.exportNullable(value2));
            return true;
        });
        return result;
    }
}

