/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.LinkedHashMap;
import java.util.Objects;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;

public final class VmDynamic
extends VmObject {
    private int cachedRegularMemberCount = -1;
    private final int length;

    public static VmDynamic empty() {
        return EmptyHolder.EMPTY;
    }

    public VmDynamic(MaterializedFrame enclosingFrame, VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members, int length2) {
        super(enclosingFrame, Objects.requireNonNull(parent), members);
        this.length = length2;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getDynamicClass();
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasElements() {
        return this.length != 0;
    }

    @Override
    public boolean isSequence() {
        return this.hasElements();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PObject export() {
        LinkedHashMap<String, Object> properties = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.cachedValues));
        this.iterateMemberValues((key2, member, value2) -> {
            properties.put(key2.toString(), VmValue.exportNullable(value2));
            return true;
        });
        return new PObject(PClassInfo.Dynamic, properties);
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitDynamic(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertDynamic(this, path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmDynamic)) {
            return false;
        }
        VmDynamic other = (VmDynamic)obj;
        this.force(false);
        other.force(false);
        if (this.getRegularMemberCount() != other.getRegularMemberCount()) {
            return false;
        }
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (this.isHiddenOrLocalProperty(key2)) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            Object otherValue = other.getCachedValue(key2);
            if (value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.force(false);
        int result = 0;
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (this.isHiddenOrLocalProperty(key2)) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            result += key2.hashCode() ^ value2.hashCode();
        }
        this.cachedHash = result;
        return result;
    }

    public int getRegularMemberCount() {
        if (this.cachedRegularMemberCount != -1) {
            return this.cachedRegularMemberCount;
        }
        int result = 0;
        for (Object key2 : this.cachedValues.getKeys()) {
            if (this.isHiddenOrLocalProperty(key2)) continue;
            ++result;
        }
        this.cachedRegularMemberCount = result;
        return result;
    }

    private boolean isHiddenOrLocalProperty(Object key2) {
        return key2 instanceof Identifier && (key2 == Identifier.DEFAULT || ((Identifier)key2).isLocalProp());
    }

    private static final class EmptyHolder {
        private static final VmDynamic EMPTY = new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), EconomicMaps.create(), 0);

        private EmptyHolder() {
        }
    }
}

