/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.project.CanonicalPackageUri;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.Json;
import org.pkl.core.util.json.JsonWriter;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;

public final class ProjectDeps {
    private static final Set<Integer> supportedSchemaVersions = Set.of(Integer.valueOf(1));
    private final EconomicMap<CanonicalPackageUri, Dependency> resolvedDependencies;

    public static ProjectDeps parse(Path path) throws IOException, URISyntaxException, Json.JsonParseException {
        String input = Files.readString(path);
        return ProjectDeps.parse(input);
    }

    public static ProjectDeps parse(String input) throws Json.JsonParseException {
        Json.JsObject parsed = Json.parseObject(input);
        int schemaVersion = parsed.getInt("schemaVersion");
        if (!supportedSchemaVersions.contains(schemaVersion)) {
            throw new PackageLoadError("unsupportedProjectDepsVersion", schemaVersion);
        }
        EconomicMap resolvedDependencies = parsed.get("resolvedDependencies", ProjectDeps::parseResolvedDependencies);
        return new ProjectDeps(resolvedDependencies);
    }

    private static EconomicMap<CanonicalPackageUri, Dependency> parseResolvedDependencies(Object object) throws Json.JsonParseException, URISyntaxException {
        if (!(object instanceof Json.JsObject)) {
            throw new Json.FormatException("resolvedDependencies", "object", object.getClass());
        }
        Json.JsObject jsObj = (Json.JsObject)object;
        EconomicMap<CanonicalPackageUri, Dependency> ret = EconomicMaps.create(jsObj.size());
        for (Map.Entry<String, Object> entry : jsObj.entrySet()) {
            Dependency resolvedDependency = ProjectDeps.parseResolvedDependency(entry);
            CanonicalPackageUri canonicalPackageUri = CanonicalPackageUri.of(entry.getKey());
            ret.put(canonicalPackageUri, resolvedDependency);
        }
        return ret;
    }

    private static Dependency parseResolvedDependency(Map.Entry<String, Object> entry) throws Json.JsonParseException {
        Object input = entry.getValue();
        if (!(input instanceof Json.JsObject)) {
            throw new VmExceptionBuilder().evalError("invalid object", new Object[0]).build();
        }
        Json.JsObject obj = (Json.JsObject)input;
        String type = obj.getString("type");
        PackageUri uri = obj.get("uri", PackageUtils::parsePackageUriWithoutChecksums);
        if (type.equals("remote")) {
            Checksums checksums = DependencyMetadata.parseChecksums(obj.getObject("checksums"));
            return new Dependency.RemoteDependency(uri, checksums);
        }
        assert (type.equals("local"));
        String pathStr = obj.getString("path");
        return new Dependency.LocalDependency(uri, Path.of(pathStr, new String[0]));
    }

    public ProjectDeps(EconomicMap<CanonicalPackageUri, Dependency> resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies;
    }

    @Nullable
    public Dependency get(CanonicalPackageUri canonicalPackageUri) {
        return (Dependency)this.resolvedDependencies.get(canonicalPackageUri);
    }

    public void writeTo(OutputStream out) throws IOException {
        new ProjectDepsWriter(out, this.resolvedDependencies).write();
    }

    public String toString() {
        return "ProjectDeps {" + this.resolvedDependencies + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDeps that = (ProjectDeps)o;
        return EconomicMaps.equals(this.resolvedDependencies, that.resolvedDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedDependencies);
    }

    private static final class ProjectDepsWriter {
        private final EconomicMap<CanonicalPackageUri, Dependency> projectDeps;
        private final JsonWriter jsonWriter;

        private ProjectDepsWriter(OutputStream out, EconomicMap<CanonicalPackageUri, Dependency> projectDeps) {
            this.jsonWriter = new JsonWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            this.jsonWriter.setIndent("  ");
            this.projectDeps = projectDeps;
        }

        private void writeChecksums(Checksums checksums) throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("sha256").value(checksums.getSha256());
            this.jsonWriter.endObject();
        }

        private void writeRemoteDependency(Dependency.RemoteDependency remoteDependency) throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("type").value("remote");
            this.jsonWriter.name("uri").value(remoteDependency.getPackageUri().toString());
            this.jsonWriter.name("checksums");
            assert (remoteDependency.getChecksums() != null);
            this.writeChecksums(remoteDependency.getChecksums());
            this.jsonWriter.endObject();
        }

        private void writeLocalDependency(Dependency.LocalDependency localDependency) throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("type").value("local");
            this.jsonWriter.name("uri").value(localDependency.getPackageUri().toString());
            this.jsonWriter.name("path").value(IoUtils.toNormalizedPathString(localDependency.getPath()));
            this.jsonWriter.endObject();
        }

        private void write() throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("schemaVersion").value(1L);
            this.jsonWriter.name("resolvedDependencies");
            this.jsonWriter.beginObject();
            UnmodifiableMapCursor cursor = this.projectDeps.getEntries();
            while (cursor.advance()) {
                this.jsonWriter.name(((CanonicalPackageUri)cursor.getKey()).toString());
                Dependency dependency = (Dependency)cursor.getValue();
                if (dependency instanceof Dependency.LocalDependency) {
                    Dependency.LocalDependency localDependency = (Dependency.LocalDependency)dependency;
                    this.writeLocalDependency(localDependency);
                    continue;
                }
                this.writeRemoteDependency((Dependency.RemoteDependency)dependency);
            }
            this.jsonWriter.endObject();
            this.jsonWriter.endObject();
            this.jsonWriter.close();
        }
    }
}

