/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.pkl.core.Version;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.IoUtils;

public final class PackageAssetUri {
    private final URI uri;
    private final PackageUri packageUri;
    private final String assetPath;

    public static PackageAssetUri create(URI uri) {
        try {
            return new PackageAssetUri(uri);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    public PackageAssetUri(PackageUri packageUri, String assetPath) {
        this.uri = packageUri.getUri().resolve("#" + assetPath);
        this.packageUri = packageUri;
        this.assetPath = assetPath;
    }

    public PackageAssetUri(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public PackageAssetUri(URI uri) throws URISyntaxException {
        this.uri = uri;
        this.packageUri = new PackageUri(uri);
        String fragment = uri.getFragment();
        if (fragment == null) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidUriMissingFragment", uri));
        }
        if (!fragment.startsWith("/")) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("cannotHaveRelativeFragment", fragment, uri));
        }
        this.assetPath = fragment;
    }

    public URI getUri() {
        return this.uri;
    }

    public PackageUri getPackageUri() {
        return this.packageUri;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public Version getVersion() {
        return this.packageUri.getVersion();
    }

    public String toString() {
        return this.uri.toString();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageAssetUri that = (PackageAssetUri)o;
        return this.getUri().equals(that.getUri());
    }

    public PackageAssetUri resolve(String path) {
        String resolvedPath = IoUtils.toNormalizedPathString(Path.of(this.assetPath, new String[0]).resolve(path));
        return new PackageAssetUri(this.packageUri, resolvedPath);
    }
}

