/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.util.IoUtils;

public final class ModuleKeyFactories {
    public static final ModuleKeyFactory standardLibrary = new StandardLibrary();
    public static final ModuleKeyFactory file = new File();
    public static final ModuleKeyFactory http = new Http();
    public static final ModuleKeyFactory genericUrl = new GenericUrl();
    public static final ModuleKeyFactory pkg = new Package();
    public static final ModuleKeyFactory projectpackage = new ProjectPackage();

    private ModuleKeyFactories() {
    }

    public static List<ModuleKeyFactory> fromServiceProviders() {
        return FromServiceProviders.INSTANCE;
    }

    public static ModuleKeyFactory modulePath(ModulePathResolver resolver) {
        return new ModulePath(resolver);
    }

    public static ModuleKeyFactory classPath(ClassLoader classLoader) {
        return new ClassPath(classLoader);
    }

    public static void closeQuietly(Iterable<ModuleKeyFactory> factories) {
        for (ModuleKeyFactory factory : factories) {
            try {
                factory.close();
            }
            catch (Exception exception) {}
        }
    }

    private static class FromServiceProviders {
        private static final List<ModuleKeyFactory> INSTANCE;

        private FromServiceProviders() {
        }

        static {
            ServiceLoader<ModuleKeyFactory> loader = IoUtils.createServiceLoader(ModuleKeyFactory.class);
            ArrayList factories = new ArrayList();
            loader.forEach(factories::add);
            INSTANCE = Collections.unmodifiableList(factories);
        }
    }

    private static class ModulePath
    implements ModuleKeyFactory {
        final ModulePathResolver resolver;

        public ModulePath(ModulePathResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            if (uri.getScheme().equals("modulepath")) {
                return Optional.of(ModuleKeys.modulePath(uri, this.resolver));
            }
            if (uri.getScheme().equals("jar")) {
                try {
                    Path path = Paths.get(uri);
                    return Optional.of(ModuleKeys.modulePath(URI.create("modulepath:" + path), this.resolver));
                }
                catch (FileSystemNotFoundException e2) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }

        @Override
        public void close() {
            this.resolver.close();
        }
    }

    private static class ClassPath
    implements ModuleKeyFactory {
        private final ClassLoader classLoader;

        public ClassPath(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            if (!uri.getScheme().equals("modulepath")) {
                return Optional.empty();
            }
            return Optional.of(ModuleKeys.classPath(uri, this.classLoader));
        }
    }

    private static class StandardLibrary
    implements ModuleKeyFactory {
        private StandardLibrary() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            if (!uri.getScheme().equals("pkl")) {
                return Optional.empty();
            }
            return Optional.of(ModuleKeys.standardLibrary(uri));
        }
    }

    private static class File
    implements ModuleKeyFactory {
        private File() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            if (uri.getScheme().equalsIgnoreCase("file")) {
                return Optional.of(ModuleKeys.file(uri));
            }
            if (uri.getScheme().equalsIgnoreCase("jar")) {
                return Optional.empty();
            }
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equalsIgnoreCase(uri.getScheme())) continue;
                return Optional.of(ModuleKeys.file(uri));
            }
            return Optional.empty();
        }
    }

    private static class Http
    implements ModuleKeyFactory {
        private Http() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            String scheme = uri.getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                return Optional.of(ModuleKeys.http(uri));
            }
            return Optional.empty();
        }
    }

    private static class GenericUrl
    implements ModuleKeyFactory {
        private GenericUrl() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) {
            if (!uri.isAbsolute()) {
                return Optional.empty();
            }
            if (uri.isOpaque() && !"jar".equalsIgnoreCase(uri.getScheme())) {
                return Optional.empty();
            }
            return Optional.of(ModuleKeys.genericUrl(uri));
        }
    }

    private static final class Package
    implements ModuleKeyFactory {
        private Package() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) throws URISyntaxException {
            if (uri.getScheme().equalsIgnoreCase("package")) {
                return Optional.of(ModuleKeys.pkg(uri));
            }
            return Optional.empty();
        }
    }

    private static final class ProjectPackage
    implements ModuleKeyFactory {
        private ProjectPackage() {
        }

        @Override
        public Optional<ModuleKey> create(URI uri) throws URISyntaxException {
            if (uri.getScheme().equalsIgnoreCase("projectpackage")) {
                return Optional.of(ModuleKeys.projectpackage(uri));
            }
            return Optional.empty();
        }
    }
}

