/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class DefaultPropertyBodyNode
extends ExpressionNode {
    private final Identifier propertyName;
    @Nullable
    private final PropertyTypeNode typeNode;

    public DefaultPropertyBodyNode(SourceSection sourceSection, Identifier propertyName, @Nullable PropertyTypeNode typeNode) {
        super(sourceSection);
        this.propertyName = propertyName;
        this.typeNode = typeNode;
    }

    public boolean isUndefined() {
        return this.typeNode == null || this.typeNode.getDefaultValue() == null;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        Object defaultValue;
        if (this.typeNode != null && (defaultValue = this.typeNode.getDefaultValue()) != null) {
            return defaultValue;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().undefinedPropertyValue(this.propertyName, VmUtils.getReceiver(frame)).build();
    }
}

