/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.UnexpectedResultException;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class GeneratorWhenNode
extends GeneratorMemberNode {
    @Node.Child
    private ExpressionNode conditionNode;
    @Node.Children
    private final GeneratorMemberNode[] thenNodes;
    @Node.Children
    private final GeneratorMemberNode[] elseNodes;

    public GeneratorWhenNode(SourceSection sourceSection, ExpressionNode conditionNode, GeneratorMemberNode[] thenNodes, GeneratorMemberNode[] elseNodes) {
        super(sourceSection);
        this.conditionNode = conditionNode;
        this.thenNodes = thenNodes;
        this.elseNodes = elseNodes;
    }

    @Override
    @ExplodeLoop
    public void execute(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data) {
        boolean condition;
        try {
            condition = this.conditionNode.executeBoolean(frame);
        }
        catch (UnexpectedResultException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().typeMismatch(e2.getResult(), BaseModule.getBooleanClass()).withSourceSection(this.conditionNode.getSourceSection()).build();
        }
        for (GeneratorMemberNode node : condition ? this.thenNodes : this.elseNodes) {
            node.execute(frame, parent, data);
        }
    }
}

