/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="-")
public abstract class SubtractionNode
extends BinaryExpressionNode {
    protected SubtractionNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    protected long eval(long left, long right) {
        try {
            return StrictMath.subtractExact(left, right);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("integerOverflow", new Object[0]).build();
        }
    }

    @Specialization
    protected double eval(long left, double right) {
        return (double)left - right;
    }

    @Specialization
    protected double eval(double left, long right) {
        return left - (double)right;
    }

    @Specialization
    protected double eval(double left, double right) {
        return left - right;
    }

    @Specialization
    protected VmDuration eval(VmDuration left, VmDuration right) {
        return left.subtract(right);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, VmDataSize right) {
        return left.subtract(right);
    }
}

