/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="[]")
public abstract class SubscriptNode
extends BinaryExpressionNode {
    protected SubscriptNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected String eval(String receiver, long index) {
        int charIndex = VmUtils.codePointOffsetToCharOffset(receiver, index);
        if (charIndex == -1 || charIndex == receiver.length()) {
            throw this.exceptionBuilder().evalError("charIndexOutOfRange", index, 0, receiver.codePointCount(0, receiver.length()) - 1).withSourceSection(this.getRightNode().getSourceSection()).withProgramValue("String", receiver).build();
        }
        if (Character.isHighSurrogate(receiver.charAt(charIndex))) {
            return receiver.substring(charIndex, charIndex + 2);
        }
        return receiver.substring(charIndex, charIndex + 1);
    }

    @Specialization
    protected Object eval(VmList receiver, long index) {
        if (index < 0L || index >= (long)receiver.getLength()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, receiver.getLength() - 1).withProgramValue("Collection", receiver).build();
        }
        return receiver.get(index);
    }

    @Specialization
    protected Object eval(VmMap receiver, Object key2) {
        Object result = receiver.getOrNull(key2);
        if (result != null) {
            return result;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindKey(receiver, key2).build();
    }

    @Specialization
    protected Object eval(VmListing listing, long index, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        Object result = VmUtils.readMemberOrNull((VmObjectLike)listing, (Object)index, callNode);
        if (result != null) {
            return result;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, listing.getLength() - 1).build();
    }

    @Specialization
    protected Object eval(VmMapping mapping, Object key2, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        return this.readMember(mapping, key2, callNode);
    }

    @Specialization
    protected Object eval(VmDynamic dynamic, Object key2, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        return this.readMember(dynamic, key2, callNode);
    }

    private Object readMember(VmObject object, Object key2, IndirectCallNode callNode) {
        Object result = VmUtils.readMemberOrNull((VmObjectLike)object, key2, callNode);
        if (result != null) {
            return result;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindMember(object, key2).build();
    }
}

