/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmStackOverflowException;
import org.pkl.core.runtime.VmTypes;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.TypeSystemReference;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.nodes.RootNode;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(language="Pkl")
@TypeSystemReference(value=VmTypes.class)
public abstract class PklRootNode
extends RootNode {
    protected PklRootNode(@Nullable VmLanguage language, FrameDescriptor descriptor) {
        super(language, descriptor);
    }

    @Override
    public abstract SourceSection getSourceSection();

    @Override
    @Nullable
    public abstract String getName();

    protected final Object executeBody(VirtualFrame frame, ExpressionNode bodyNode) {
        try {
            return bodyNode.executeGeneric(frame);
        }
        catch (VmException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2;
        }
        catch (StackOverflowError e3) {
            CompilerDirectives.transferToInterpreter();
            throw new VmStackOverflowException(e3);
        }
        catch (Exception e4) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().bug(e4.getMessage(), new Object[0]).withCause(e4).build();
        }
    }

    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder().withLocation(this);
    }
}

