/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.pkl.core.NoSuchPropertyException;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.Nullable;

public final class PModule
extends PObject {
    private static final long serialVersionUID = 0L;
    private final URI moduleUri;
    private final String moduleName;

    public PModule(URI moduleUri, String moduleName, PClassInfo<?> classInfo, Map<String, Object> properties) {
        super(classInfo, properties);
        this.moduleUri = Objects.requireNonNull(moduleUri, "moduleUri");
        this.moduleName = Objects.requireNonNull(moduleName, "moduleName");
    }

    public URI getModuleUri() {
        return this.moduleUri;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        if (result != null) {
            return result;
        }
        throw new NoSuchPropertyException(String.format("Module `%s` does not have a property named `%s`. Available properties: %s", this.moduleName, name, this.properties.keySet()), name);
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitModule(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PModule)) {
            return false;
        }
        PModule other = (PModule)obj;
        return this.moduleUri.equals(other.moduleUri) && this.moduleName.equals(other.moduleName) && this.classInfo.equals(other.classInfo) && this.properties.equals(other.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.moduleUri, this.moduleName, this.classInfo, this.properties);
    }

    @Override
    public String toString() {
        return this.render(this.moduleName);
    }
}

