/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.Objects;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.Value;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.MathUtils;
import org.pkl.core.util.Nullable;

public final class DataSize
implements Value {
    private static final long serialVersionUID = 0L;
    private final double value;
    private final DataSizeUnit unit;

    public DataSize(double value2, DataSizeUnit unit2) {
        this.value = value2;
        this.unit = Objects.requireNonNull(unit2, "unit");
    }

    public static DataSize ofBytes(double value2) {
        return new DataSize(value2, DataSizeUnit.BYTES);
    }

    public static DataSize ofKilobytes(double value2) {
        return new DataSize(value2, DataSizeUnit.KILOBYTES);
    }

    public static DataSize ofKibibytes(double value2) {
        return new DataSize(value2, DataSizeUnit.KIBIBYTES);
    }

    public static DataSize ofMegabytes(double value2) {
        return new DataSize(value2, DataSizeUnit.MEGABYTES);
    }

    public static DataSize ofMebibytes(double value2) {
        return new DataSize(value2, DataSizeUnit.MEBIBYTES);
    }

    public static DataSize ofGigabytes(double value2) {
        return new DataSize(value2, DataSizeUnit.GIGABYTES);
    }

    public static DataSize ofGibibytes(double value2) {
        return new DataSize(value2, DataSizeUnit.GIBIBYTES);
    }

    public static DataSize ofTerabytes(double value2) {
        return new DataSize(value2, DataSizeUnit.TERABYTES);
    }

    public static DataSize ofTebibytes(double value2) {
        return new DataSize(value2, DataSizeUnit.TEBIBYTES);
    }

    public static DataSize ofPetabytes(double value2) {
        return new DataSize(value2, DataSizeUnit.PETABYTES);
    }

    public static DataSize ofPebibytes(double value2) {
        return new DataSize(value2, DataSizeUnit.PEBIBYTES);
    }

    public double getValue() {
        return this.value;
    }

    public DataSizeUnit getUnit() {
        return this.unit;
    }

    public double inBytes() {
        return this.convertValueTo(DataSizeUnit.BYTES);
    }

    public double inKilobytes() {
        return this.convertValueTo(DataSizeUnit.KILOBYTES);
    }

    public double inKibibytes() {
        return this.convertValueTo(DataSizeUnit.KIBIBYTES);
    }

    public double inMegabytes() {
        return this.convertValueTo(DataSizeUnit.MEGABYTES);
    }

    public double inMebibytes() {
        return this.convertValueTo(DataSizeUnit.MEBIBYTES);
    }

    public double inGigabytes() {
        return this.convertValueTo(DataSizeUnit.GIGABYTES);
    }

    public double inGibibytes() {
        return this.convertValueTo(DataSizeUnit.GIBIBYTES);
    }

    public double inTerabytes() {
        return this.convertValueTo(DataSizeUnit.TERABYTES);
    }

    public double inTebibytes() {
        return this.convertValueTo(DataSizeUnit.TEBIBYTES);
    }

    public double inPetabytes() {
        return this.convertValueTo(DataSizeUnit.PETABYTES);
    }

    public double inPebibytes() {
        return this.convertValueTo(DataSizeUnit.PEBIBYTES);
    }

    public long inWholeBytes() {
        return Math.round(this.inBytes());
    }

    public long inWholeKilobytes() {
        return Math.round(this.inKilobytes());
    }

    public long inWholeKibibytes() {
        return Math.round(this.inKibibytes());
    }

    public long inWholeMegabytes() {
        return Math.round(this.inMegabytes());
    }

    public long inWholeMebibytes() {
        return Math.round(this.inMebibytes());
    }

    public long inWholeGigabytes() {
        return Math.round(this.inGigabytes());
    }

    public long inWholeGibibytes() {
        return Math.round(this.inGibibytes());
    }

    public long inWholeTerabytes() {
        return Math.round(this.inTerabytes());
    }

    public long inWholeTebibytes() {
        return Math.round(this.inTebibytes());
    }

    public long inWholePetabytes() {
        return Math.round(this.inPetabytes());
    }

    public long inWholePebibytes() {
        return Math.round(this.inPebibytes());
    }

    public DataSize convertTo(DataSizeUnit other) {
        return new DataSize(this.convertValueTo(other), other);
    }

    public double convertValueTo(DataSizeUnit other) {
        return this.value * (double)this.unit.getBytes() / (double)other.getBytes();
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitDataSize(this);
    }

    @Override
    public <T> T accept(ValueConverter<T> converter) {
        return converter.convertDataSize(this);
    }

    @Override
    public PClassInfo<?> getClassInfo() {
        return PClassInfo.DataSize;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataSize)) {
            return false;
        }
        DataSize other = (DataSize)obj;
        return this.convertValueTo(DataSizeUnit.BYTES) == other.convertValueTo(DataSizeUnit.BYTES);
    }

    public int hashCode() {
        return Double.hashCode(this.convertValueTo(DataSizeUnit.BYTES));
    }

    public String toString() {
        return MathUtils.isMathematicalInteger(this.value) ? (long)this.value + "." + this.unit : this.value + "." + this.unit;
    }
}

