/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.Pair;
import org.pkl.core.util.Nullable;

final class PPairToPair
implements ConverterFactory {
    PPairToPair() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        if (sourceType != PClassInfo.Pair) {
            return Optional.empty();
        }
        Class<?> targetClass = Reflection.toRawType(targetType);
        if (!Pair.class.isAssignableFrom(targetClass)) {
            return Optional.empty();
        }
        ParameterizedType pairType = (ParameterizedType)Reflection.getExactSupertype(targetType, Pair.class);
        return Optional.of(new ConverterImpl(pairType.getActualTypeArguments()[0], pairType.getActualTypeArguments()[1]));
    }

    private static class ConverterImpl<F, S>
    implements Converter<Pair<Object, Object>, Pair<F, S>> {
        private final Type firstTargetType;
        private final Type secondTargetType;
        private PClassInfo<Object> firstCachedType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, F> firstCachedConverter;
        private PClassInfo<Object> secondCachedType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, S> secondCachedConverter;

        public ConverterImpl(Type firstTargetType, Type secondTargetType) {
            this.firstTargetType = firstTargetType;
            this.secondTargetType = secondTargetType;
        }

        @Override
        public Pair<F, S> convert(Pair<Object, Object> value2, ValueMapper valueMapper) {
            Object second2;
            Object first2 = value2.getFirst();
            if (!this.firstCachedType.isExactClassOf(first2)) {
                this.firstCachedType = PClassInfo.forValue(first2);
                this.firstCachedConverter = valueMapper.getConverter(this.firstCachedType, this.firstTargetType);
            }
            if (!this.secondCachedType.isExactClassOf(second2 = value2.getSecond())) {
                this.secondCachedType = PClassInfo.forValue(second2);
                this.secondCachedConverter = valueMapper.getConverter(this.secondCachedType, this.secondTargetType);
            }
            assert (this.firstCachedConverter != null);
            assert (this.secondCachedConverter != null);
            return new Pair<F, S>(this.firstCachedConverter.convert(first2, valueMapper), this.secondCachedConverter.convert(second2, valueMapper));
        }
    }
}

