module org.graalvm.truffle {
    /* static phase */ requires java.desktop;
    requires java.logging;
    requires java.management;
    requires java.sql;
    requires jdk.management;
    requires jdk.unsupported;
    /* transitive */ requires org.graalvm.sdk;

    exports com.oracle.truffle.api;
    exports com.oracle.truffle.api.debug;
    exports com.oracle.truffle.api.dsl;
    exports com.oracle.truffle.api.exception;
    exports com.oracle.truffle.api.frame;
    exports com.oracle.truffle.api.impl to jdk.internal.vm.compiler, org.graalvm.locator;
    exports com.oracle.truffle.api.instrumentation;
    exports com.oracle.truffle.api.interop;
    exports com.oracle.truffle.api.io;
    exports com.oracle.truffle.api.library;
    exports com.oracle.truffle.api.memory;
    exports com.oracle.truffle.api.nodes;
    exports com.oracle.truffle.api.object;
    exports com.oracle.truffle.api.profiles;
    exports com.oracle.truffle.api.source;
    exports com.oracle.truffle.api.staticobject;
    exports com.oracle.truffle.api.strings;
    exports com.oracle.truffle.api.utilities;
    exports com.oracle.truffle.object to com.oracle.graal.graal_enterprise, jdk.internal.vm.compiler;

    provides TruffleInstrument.Provider with DebuggerInstrumentProvider;
    provides DefaultExportProvider with DynamicObjectLibraryImplGen.DynamicObjectLibraryProvider;
    provides LayoutFactory with CoreLayoutFactory;
    provides AbstractPolyglotImpl with PolyglotImpl;

}

