/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.pitest.maven.report.generator.ReportGenerationContext;
import org.pitest.maven.report.generator.ReportGenerationManager;
import org.pitest.util.PitError;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class PitReportMojo
extends AbstractMavenReport {
    @Component
    private Renderer siteRenderer;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="pit.report.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="reportsDirectory", defaultValue="${project.build.directory}/pit-reports")
    private File reportsDirectory;
    @Parameter(property="pit.report.sourceDataFormats", defaultValue="HTML")
    private List<String> sourceDataFormats;
    @Parameter(property="pit.report.name", defaultValue="PIT Test Report")
    private String siteReportName;
    @Parameter(property="pit.report.description", defaultValue="Report of the pit test coverage")
    private String siteReportDescription;
    @Parameter(property="pit.report.outputdir", defaultValue="pit-reports")
    private String siteReportDirectory;
    @Parameter(property="pit.inputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="pit.outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    private ReportGenerationManager reportGenerationManager = new ReportGenerationManager();

    public String getOutputName() {
        return this.siteReportDirectory + File.separator + "index";
    }

    public String getName(Locale locale) {
        return this.siteReportName;
    }

    public String getDescription(Locale locale) {
        return this.siteReportDescription;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.reportsDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().debug((CharSequence)"PitReportMojo - starting");
        if (!this.reportsDirectory.exists()) {
            throw new PitError("could not find reports directory [" + this.reportsDirectory + "]");
        }
        if (!this.reportsDirectory.canRead()) {
            throw new PitError("reports directory [" + this.reportsDirectory + "] not readable");
        }
        if (!this.reportsDirectory.isDirectory()) {
            throw new PitError("reports directory [" + this.reportsDirectory + "] is actually a file, it must be a directory");
        }
        this.reportGenerationManager.generateSiteReport(this.buildReportGenerationContext(locale));
        this.getLog().debug((CharSequence)"PitReportMojo - ending");
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public List<String> getSourceDataFormats() {
        return this.sourceDataFormats;
    }

    public String getInputEncoding() {
        if (this.inputEncoding != null) {
            return this.inputEncoding;
        }
        return Charset.defaultCharset().name();
    }

    public String getOutputEncoding() {
        if (this.outputEncoding != null) {
            return this.outputEncoding;
        }
        return Charset.defaultCharset().name();
    }

    private ReportGenerationContext buildReportGenerationContext(Locale locale) {
        return new ReportGenerationContext(locale, this.getSink(), this.reportsDirectory, new File(this.getReportOutputDirectory().getAbsolutePath() + File.separator + this.siteReportDirectory), this.getLog(), this.getSourceDataFormats());
    }
}

