/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.util.Glob;

public class SurefireConfigConverter {
    private final boolean parseArgLine;

    public SurefireConfigConverter(boolean parseArgLine) {
        this.parseArgLine = parseArgLine;
    }

    public ReportOptions update(ReportOptions option, Xpp3Dom configuration) {
        if (configuration == null) {
            return option;
        }
        this.convertExcludes(option, configuration);
        this.convertGroups(option, configuration);
        this.convertTestFailureIgnore(option, configuration);
        if (this.parseArgLine) {
            this.convertArgLine(option, configuration);
        }
        return option;
    }

    private void convertGroups(ReportOptions option, Xpp3Dom configuration) {
        TestGroupConfig existing = option.getGroupConfig();
        if (existing == null || existing.getExcludedGroups().isEmpty() && existing.getIncludedGroups().isEmpty()) {
            List<String> groups = this.extractStrings("groups", configuration);
            List<String> excluded = this.extractStrings("excludedGroups", configuration);
            TestGroupConfig gc = new TestGroupConfig(excluded, groups);
            option.setGroupConfig(gc);
        }
    }

    private List<String> extractStrings(String element, Xpp3Dom configuration) {
        Xpp3Dom groups = configuration.getChild(element);
        if (groups != null) {
            return Arrays.stream(groups.getValue().split("[ ,]+")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void convertExcludes(ReportOptions option, Xpp3Dom configuration) {
        ArrayList excludes = new ArrayList();
        List surefireExcludes = this.extract("excludes", configuration).stream().filter(Objects::nonNull).map(this::filenameToClassFilter).collect(Collectors.toList());
        excludes.addAll(surefireExcludes);
        excludes.addAll(option.getExcludedTestClasses());
        option.setExcludedTestClasses(excludes);
    }

    private void convertArgLine(ReportOptions option, Xpp3Dom configuration) {
        Xpp3Dom argLine = configuration.getChild("argLine");
        if (argLine != null) {
            String existing = option.getArgLine() != null ? option.getArgLine() + " " : "";
            option.setArgLine(existing + argLine.getValue());
        }
    }

    private Predicate<String> filenameToClassFilter(String filename) {
        return new Glob(filename.replace(".java", "").replace("/", "."));
    }

    private List<String> extract(String childname, Xpp3Dom config) {
        Xpp3Dom subelement = config.getChild(childname);
        if (subelement != null) {
            Xpp3Dom[] children;
            LinkedList<String> result = new LinkedList<String>();
            for (Xpp3Dom child : children = subelement.getChildren()) {
                result.add(child.getValue());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void convertTestFailureIgnore(ReportOptions option, Xpp3Dom configuration) {
        Xpp3Dom testFailureIgnore = configuration.getChild("testFailureIgnore");
        if (testFailureIgnore != null) {
            option.setSkipFailingTests(Boolean.parseBoolean(testFailureIgnore.getValue()));
        }
    }
}

