/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class LimitNumberOfMutationPerClassFilter
implements MutationInterceptor {
    private final int maxMutationsPerClass;

    public LimitNumberOfMutationPerClassFilter(int max) {
        this.maxMutationsPerClass = max;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (mutations.size() <= this.maxMutationsPerClass) {
            return mutations;
        }
        return this.createEvenlyDistributedSampling(mutations);
    }

    private Collection<MutationDetails> createEvenlyDistributedSampling(Collection<MutationDetails> mutations) {
        ArrayList<MutationDetails> filtered = new ArrayList<MutationDetails>(this.maxMutationsPerClass);
        int step = mutations.size() / this.maxMutationsPerClass;
        Iterator<MutationDetails> it = mutations.iterator();
        while (it.hasNext()) {
            MutationDetails value = null;
            for (int i = 0; it.hasNext() && i != step; ++i) {
                value = it.next();
            }
            if (filtered.size() == this.maxMutationsPerClass) continue;
            filtered.add(value);
        }
        return filtered;
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
    }

    @Override
    public void end() {
    }
}

