/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassHash;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.mutationtest.ClassHistory;
import org.pitest.mutationtest.History;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.incremental.CodeHistory;
import org.pitest.mutationtest.incremental.IncrementalAnalyser;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

public class ObjectOutputStreamHistory
implements History {
    private static final Logger LOG = Log.getLogger();
    private final CodeSource code;
    private final WriterFactory outputFactory;
    private final BufferedReader input;
    private final Map<MutationIdentifier, MutationStatusTestPair> previousResults = new HashMap<MutationIdentifier, MutationStatusTestPair>();
    private final Map<ClassName, ClassHistory> previousClassPath = new HashMap<ClassName, ClassHistory>();
    private CoverageDatabase coverageData;

    public ObjectOutputStreamHistory(CodeSource code, WriterFactory output, Optional<Reader> input) {
        this.code = code;
        this.outputFactory = output;
        this.input = this.createReader(input);
    }

    private BufferedReader createReader(Optional<Reader> input) {
        return input.map(BufferedReader::new).orElse(null);
    }

    @Override
    public void recordResult(MutationResult result) {
        PrintWriter output = this.outputFactory.create();
        output.println(this.serialize(new IdResult(result.getDetails().getId(), result.getStatusTestPair())));
        output.flush();
    }

    @Override
    public List<MutationResult> analyse(List<MutationDetails> mutationsForClasses) {
        IncrementalAnalyser analyser = new IncrementalAnalyser(new CodeHistory(this.code, this.previousResults, this.previousClassPath), this.coverageData);
        return analyser.analyse(mutationsForClasses);
    }

    @Override
    public void close() {
    }

    @Override
    public void initialize() {
        if (this.input != null) {
            this.restoreClassPath();
            this.restoreResults();
            try {
                this.input.close();
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException((Throwable)e);
            }
        }
    }

    @Override
    public void processCoverage(CoverageDatabase coverageData) {
        this.coverageData = coverageData;
        this.recordClassPath(coverageData);
    }

    private void recordClassPath(CoverageDatabase coverageData) {
        Set<ClassName> allClassNames = this.code.getAllClassAndTestNames();
        List ids = this.code.fetchClassHashes(allClassNames).stream().map(ClassHash::getHierarchicalId).sorted(Comparator.comparing(HierarchicalClassId::getName)).collect(Collectors.toList());
        PrintWriter output = this.outputFactory.create();
        output.println(ids.size());
        for (HierarchicalClassId each : ids) {
            ClassHistory coverage = new ClassHistory(each, coverageData.getCoverageIdForClass(each.getName()).toString(16));
            output.println(this.serialize(coverage));
        }
        output.flush();
    }

    private void restoreResults() {
        try {
            String line = this.input.readLine();
            while (line != null) {
                IdResult result = this.deserialize(line, IdResult.class);
                this.previousResults.put(result.id, result.status);
                line = this.input.readLine();
            }
        }
        catch (Exception e) {
            LOG.warning("Could not read previous results");
        }
    }

    private void restoreClassPath() {
        try {
            long classPathSize = Long.parseLong(this.input.readLine());
            int i = 0;
            while ((long)i != classPathSize) {
                ClassHistory coverage = this.deserialize(this.input.readLine(), ClassHistory.class);
                this.previousClassPath.put(coverage.getName(), coverage);
                ++i;
            }
        }
        catch (IOException e) {
            LOG.warning("Could not read previous classpath");
        }
    }

    private <T> T deserialize(String string, Class<T> clazz) throws IOException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(string));
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return clazz.cast(objectInputStream.readObject());
        }
        catch (ClassNotFoundException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    private <T> String serialize(T t) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(t);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    public Map<ClassName, ClassHistory> getHistoricClassPath() {
        return this.previousClassPath;
    }

    public Map<MutationIdentifier, MutationStatusTestPair> getHistoricResults() {
        return this.previousResults;
    }

    private static class IdResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final MutationIdentifier id;
        final MutationStatusTestPair status;

        IdResult(MutationIdentifier id, MutationStatusTestPair status) {
            this.id = id;
            this.status = status;
        }
    }
}

