/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.mutationtest.build.CompoundMutationInterceptor;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.FeatureSelector;
import org.pitest.plugin.FeatureSetting;

public class CompoundInterceptorFactory {
    private final FeatureSelector<MutationInterceptorFactory> features;

    public CompoundInterceptorFactory(List<FeatureSetting> features, Collection<MutationInterceptorFactory> filters) {
        this.features = new FeatureSelector(features, filters);
    }

    public CompoundMutationInterceptor createInterceptor(ReportOptions data, CoverageDatabase coverage, ClassByteArraySource source, TestPrioritiser testPrioritiser) {
        List interceptors = this.features.getActiveFeatures().stream().map(CompoundInterceptorFactory.toInterceptor(this.features, data, coverage, source, testPrioritiser)).collect(Collectors.toList());
        return new CompoundMutationInterceptor(interceptors);
    }

    private static Function<MutationInterceptorFactory, MutationInterceptor> toInterceptor(FeatureSelector<MutationInterceptorFactory> features, ReportOptions data, CoverageDatabase coverage, ClassByteArraySource source, TestPrioritiser testPrioritiser) {
        return a -> a.createInterceptor(new InterceptorParameters(features.getSettingForFeature(a.provides().name()), data, coverage, source, testPrioritiser));
    }
}

