/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.CoverageResult;
import org.pitest.mutationtest.engine.Location;
import org.pitest.testapi.Description;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataInputStream;
import sun.pitest.CodeCoverageStore;

final class Receive
implements ReceiveStrategy {
    private final Map<Integer, ClassName> classIdToName = new ConcurrentHashMap<Integer, ClassName>();
    private final Map<Long, BlockLocation> probeToBlock = new ConcurrentHashMap<Long, BlockLocation>();
    private final Consumer<CoverageResult> handler;

    Receive(Consumer<CoverageResult> handler) {
        this.handler = handler;
    }

    public void apply(byte control, SafeDataInputStream is) {
        switch (control) {
            case 32: {
                int id = is.readInt();
                String name = is.readString();
                this.classIdToName.put(id, ClassName.fromString((String)name));
                break;
            }
            case 4: {
                this.handleProbes(is);
                break;
            }
            case 16: {
                this.handleTestEnd(is);
                break;
            }
        }
    }

    private void handleProbes(SafeDataInputStream is) {
        int classId = is.readInt();
        String methodName = is.readString();
        String methodSig = is.readString();
        int first = is.readInt();
        int last = is.readInt();
        Location loc = Location.location((ClassName)this.classIdToName.get(classId), (String)methodName, (String)methodSig);
        for (int i = first; i != last + 1; ++i) {
            this.probeToBlock.put(CodeCoverageStore.encode((int)classId, (int)i), new BlockLocation(loc, i - first));
        }
    }

    private void handleTestEnd(SafeDataInputStream is) {
        Description d = (Description)is.read(Description.class);
        int numberOfResults = is.readInt();
        HashSet<BlockLocation> hits = new HashSet<BlockLocation>(numberOfResults);
        for (int i = 0; i != numberOfResults; ++i) {
            this.readProbeHit(is, hits);
        }
        this.handler.accept(this.createCoverageResult(is, d, hits));
    }

    private void readProbeHit(SafeDataInputStream is, Set<BlockLocation> hits) {
        long encoded = is.readLong();
        BlockLocation location = this.probeToBlock(encoded);
        hits.add(location);
    }

    private BlockLocation probeToBlock(long encoded) {
        return this.probeToBlock.get(encoded);
    }

    private CoverageResult createCoverageResult(SafeDataInputStream is, Description d, Collection<BlockLocation> visitedBlocks) {
        boolean isGreen = is.readBoolean();
        int executionTime = is.readInt();
        return new CoverageResult(d, executionTime, isGreen, visitedBlocks);
    }
}

