/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Hashtable;
import java.util.Map;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RelationshipType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.functions.DefaultXPathFunction;

public class VariablesAlignedFunction
extends DefaultXPathFunction {
    private static final String FUNCTION_NAME = "variablesAligned";
    private static final int[] PARAMETER_TYPES = new int[]{2, 2, 4};
    private static final String[] PARAMETER_NAMES = new String[]{"variableName", "withVariableName", "relationshipName"};
    private static final int NUM_OF_PARAMETERS = 3;
    private static final int NUM_OF_MANDATORY_PARAMETERS = 3;
    private static final boolean REPEATING_PARAMETERS = false;

    public VariablesAlignedFunction() {
        super(FUNCTION_NAME, 3, 3, false, PARAMETER_TYPES, PARAMETER_NAMES, 3);
    }

    public Map validate(FuncExtFunction excfunc, XPathContext context) {
        Hashtable ret = new Hashtable();
        boolean valid = this.validateParameters(excfunc, context);
        if (valid) {
            Variable var1 = null;
            Variable var2 = null;
            String varName1 = excfunc.getArg(0).toString();
            String varName2 = excfunc.getArg(1).toString();
            String relName = excfunc.getArg(2).toString();
            Choreography choreo = context.getSource().getEnclosingChoreography();
            Package cdlpack = context.getSource().getPackage();
            RelationshipType rel = null;
            if (cdlpack != null && (rel = cdlpack.getRelationshipType(relName)) == null) {
                context.reportError(this.getMessage("_NOT_FOUND_REL_TYPE", new Object[]{relName}));
            }
            if (choreo != null) {
                var1 = choreo.getVariable(varName1);
                if (var1 == null) {
                    context.reportError(this.getMessage("_NOT_FOUND_VARIABLE", new Object[]{varName1}));
                }
                if ((var2 = choreo.getVariable(varName2)) == null) {
                    context.reportError(this.getMessage("_NOT_FOUND_VARIABLE", new Object[]{varName2}));
                }
            }
            this.validateRelationship(rel, var1, var2, context);
        }
        return ret;
    }

    protected void validateRelationship(RelationshipType rel, Variable var1, Variable var2, XPathContext context) {
        if (rel != null && var1 != null && var2 != null) {
            String roleType1 = rel.getFirstRoleType().getName();
            String roleType2 = rel.getSecondRoleType().getName();
            if (!var1.isRoleTypeAssociatedWithContext(roleType1)) {
                context.reportError(this.getMessage("_ALIGN_VARIABLE_NOT_FIRST_ROLE", new Object[]{var1.getName(), rel.getName()}));
            }
            if (!var2.isRoleTypeAssociatedWithContext(roleType2)) {
                context.reportError(this.getMessage("_ALIGN_VARIABLE_NOT_SECOND_ROLE", new Object[]{var2.getName(), rel.getName()}));
            }
        }
    }
}

