/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Map;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.functions.RoleOrParticipantNameFunction;

public class IsVariableAvailableFunction
extends RoleOrParticipantNameFunction {
    public static final String FUNCTION_NAME = "isVariableAvailable";
    private static final int[] PARAMETER_TYPES = new int[]{2, 4};
    private static final String[] PARAMETER_NAMES = new String[]{"variableName", "roleName"};
    public static final String PARAMETER_VARIABLE_NAME = "variableName";
    private static final int NUM_OF_PARAMETERS = 2;
    private static final int NUM_OF_MANDATORY_PARAMETERS = 1;
    private static final boolean REPEATING_PARAMETERS = false;
    private static final int ROLENAME_POSITION = 1;

    public IsVariableAvailableFunction() {
        super(FUNCTION_NAME, 2, 1, false, PARAMETER_TYPES, PARAMETER_NAMES, 3, 1);
    }

    public Map validate(FuncExtFunction excfunc, XPathContext context) {
        Map ret = super.validate(excfunc, context);
        if (excfunc.getArgCount() == 2) {
            Variable var = null;
            String varName = excfunc.getArg(0).toString();
            String roleName = excfunc.getArg(1).toString();
            Choreography choreo = context.getSource().getEnclosingChoreography();
            if (choreo != null) {
                var = choreo.getVariable(varName);
            }
            if (var != null) {
                this.validateVariableAtRoleOrParticipant(var, roleName, context);
                ret = this.buildReturnParameters(roleName, var, context);
            } else {
                context.reportError(this.getMessage("_NOT_FOUND_VARIABLE", new Object[]{varName}));
            }
        }
        return ret;
    }
}

