/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Hashtable;
import java.util.Map;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.functions.DefaultXPathFunction;

public class HasChoreographyCompletedFunction
extends DefaultXPathFunction {
    private static final String FUNCTION_NAME = "hasChoreographyCompleted";
    private static final int[] PARAMETER_TYPES = new int[]{2, 2};
    private static final String[] PARAMETER_NAMES = new String[]{"choreographyName", "choreographyInstanceId"};
    private static final int NUM_OF_PARAMETERS = 2;
    private static final int NUM_OF_MANDATORY_PARAMETERS = 1;
    private static final boolean REPEATING_PARAMETERS = false;

    public HasChoreographyCompletedFunction() {
        super(FUNCTION_NAME, 2, 1, false, PARAMETER_TYPES, PARAMETER_NAMES, 3);
    }

    public Map validate(FuncExtFunction excfunc, XPathContext context) {
        Hashtable ret = new Hashtable();
        boolean valid = this.validateParameters(excfunc, context);
        if (valid) {
            String choreoName = excfunc.getArg(0).toString();
            Choreography choreo = context.getSource().getEnclosingChoreography();
            Package cdlpack = context.getSource().getPackage();
            if (!(choreo != null && choreo.getEnclosedChoreography(choreoName) != null || cdlpack != null && cdlpack.getChoreography(choreoName) != null)) {
                context.reportError(this.getMessage("_NOT_FOUND_CHOREOGRAPHY", new Object[]{choreoName}));
            }
        }
        return ret;
    }
}

