/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.cdl.xpath.functions.DefaultXPathFunction;

public class GlobalizedTriggerFunction
extends DefaultXPathFunction {
    public static final String FUNCTION_NAME = "globalizedTrigger";
    public static final int[] PARAMETER_TYPES = new int[]{2, 2};
    public static final String[] PARAMETER_NAMES = new String[]{"expression", "roleName"};
    public static final int NUM_OF_PARAMETERS = 2;
    public static final int NUM_OF_MANDATORY_PARAMETERS = 2;
    public static final boolean REPEATING_PARAMETERS = true;

    public GlobalizedTriggerFunction() {
        super(FUNCTION_NAME, 2, 2, true, PARAMETER_TYPES, PARAMETER_NAMES, 3);
    }

    public Map validate(FuncExtFunction excfunc, XPathContext context) {
        Hashtable<String, Object[]> ret = new Hashtable<String, Object[]>();
        boolean valid = this.validateParameters(excfunc, context);
        if (valid) {
            Vector<RoleType> roles = new Vector<RoleType>();
            int count = excfunc.getArgCount();
            int i = 0;
            while (i < count) {
                String expression = excfunc.getArg(i).toString();
                String roleOrParticipantName = excfunc.getArg(i + 1).toString();
                RoleType[] roleTypes = this.getRoleTypes(roleOrParticipantName, context);
                if (roleTypes != null) {
                    int j = 0;
                    while (j < roleTypes.length) {
                        if (!context.getSource().isRoleTypeAssociatedWithContext(roleTypes[j].getName())) {
                            context.reportError(this.getMessage("_NOT_RELEVANT_ROLE_TYPE", new Object[]{roleTypes[j].getName()}));
                        } else if (!roles.contains(roleTypes[j])) {
                            roles.add(roleTypes[j]);
                        }
                        ++j;
                    }
                    ValidationResult result = XPathValidator.validateExpression(context, expression, roleTypes, null, false);
                    boolean f_roleFound = false;
                    int j2 = 0;
                    while (!f_roleFound && j2 < result.getRoleTypes().length) {
                        int k = 0;
                        while (!f_roleFound & k < roleTypes.length) {
                            if (result.getRoleTypes()[j2] == roleTypes[k]) {
                                f_roleFound = true;
                            }
                            ++k;
                        }
                        ++j2;
                    }
                    if (!f_roleFound) {
                        context.reportError(this.getMessage("_GLOBALIZED_EXPR_ROLE", new Object[]{roleOrParticipantName}));
                    }
                }
                i += 2;
            }
            Object[] roleTypes = new RoleType[roles.size()];
            roles.copyInto(roleTypes);
            ret.put("roles", roleTypes);
        }
        return ret;
    }
}

