/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath.functions;

import java.util.Hashtable;
import java.util.Map;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.functions.DefaultXPathFunction;
import org.pi4soa.common.xml.XMLUtils;

public class GetVariableFunction
extends DefaultXPathFunction {
    public static final String FUNCTION_NAME = "getVariable";
    private static final int[] PARAMETER_TYPES = new int[]{2, 2, 2, 4};
    private static final String[] PARAMETER_NAMES = new String[]{"variableName", "part", "documentPath", "roleName"};
    public static final String PARAMETER_VARIABLE_NAME = "variableName";
    public static final String PARAMETER_PART = "part";
    public static final String PARAMETER_DOCUMENT_PATH = "documentPath";
    private static final int NUM_OF_PARAMETERS = 4;
    private static final int NUM_OF_MANDATORY_PARAMETERS = 3;
    private static final boolean REPEATING_PARAMETERS = false;

    public GetVariableFunction() {
        super(FUNCTION_NAME, 4, 3, false, PARAMETER_TYPES, PARAMETER_NAMES, 1);
    }

    public Map validate(FuncExtFunction excfunc, XPathContext context) {
        Map<String, Participant> ret = new Hashtable();
        boolean valid = this.validateParameters(excfunc, context);
        if (valid) {
            Variable var = null;
            String varName = excfunc.getArg(0).toString();
            Choreography choreo = context.getChoreography();
            String roleOrParticipantName = null;
            if (XMLUtils.getPrefix((String)varName) != null) {
                context.reportError(this.getMessage("_GET_VARIABLE_NAME_NO_NAMESPACE", new Object[0]));
            } else {
                if (choreo != null) {
                    var = choreo.getVariable(varName);
                }
                if (excfunc.getArgCount() == 4) {
                    roleOrParticipantName = excfunc.getArg(3).toString();
                }
                if (var == null) {
                    if (choreo != null) {
                        context.reportError(this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{varName, choreo.getName()}));
                    } else {
                        context.reportError(this.getMessage("_NOT_FOUND_VARIABLE", new Object[]{varName}));
                    }
                } else {
                    if (roleOrParticipantName != null && this.validateRoleOrParticipant(roleOrParticipantName, context)) {
                        this.validateVariableAtRoleOrParticipant(var, roleOrParticipantName, context);
                    }
                    ret = this.buildReturnParameters(excfunc, roleOrParticipantName, var, context);
                    Participant part = context.getSource().getEnclosingChoreography().getParticipant(roleOrParticipantName);
                    if (part != null) {
                        ret.put("participant", part);
                    }
                }
            }
        }
        return ret;
    }

    protected Map buildReturnParameters(FuncExtFunction excfunc, String roleName, Variable var, XPathContext context) {
        Map ret = super.buildReturnParameters(roleName, var, context);
        if (ret != null) {
            ret.put(PARAMETER_VARIABLE_NAME, var.getName());
            ret.put(PARAMETER_PART, excfunc.getArg(1).toString());
            ret.put(PARAMETER_DOCUMENT_PATH, excfunc.getArg(2).toString());
        }
        return ret;
    }

    public boolean isParticipantBased() {
        return true;
    }
}

