/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath;

import java.util.Properties;
import org.apache.xpath.XPath;
import org.apache.xpath.functions.FuncExtFunction;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;

public class XPathProjection {
    public static final String EMPTY_EXPRESSION = "";
    public static final String GLOBALIZED_TRIGGER_START = "cdl:globalizedTrigger(";
    public static final String GLOBALIZED_TRIGGER_END = ")";
    public static final String DOUBLE_QUOTE_MARK = "\"";
    public static final String SINGLE_QUOTE_MARK = "'";
    public static final String COMMA = ",";

    public static String projectExpression(CDLType src, String expression, RoleType[] roles) {
        return XPathProjection.projectExpression(src, expression, roles, null, false);
    }

    public static String projectExpression(CDLType src, String expression, RoleType[] roles, Participant participant) {
        return XPathProjection.projectExpression(src, expression, roles, participant, true);
    }

    protected static String projectExpression(CDLType src, String expression, RoleType[] roles, Participant participant, boolean projectParticipant) {
        String ret = null;
        if (expression == null) {
            ret = EMPTY_EXPRESSION;
        } else {
            ErrorRecorder errRec = new ErrorRecorder();
            XPathContext context = DefaultXPathContext.createContext(src, src.getEnclosingChoreography(), errRec);
            ValidationResult res = XPathValidator.validateExpression(context, expression, src.getRoleTypesForContext(), null, false);
            if (res != null && errRec.getErrorCount() == 0) {
                ret = !(!XPathProjection.isRoleTypeIntersection(roles, res.getRoleTypes()) || projectParticipant && res.getParticipantDefined() && res.getParticipant() != participant) ? (XPathProjection.isGlobalizedTrigger(res) ? XPathProjection.extractGTSubExpressions(res, roles) : expression) : EMPTY_EXPRESSION;
            }
        }
        return ret;
    }

    public static boolean isRoleTypeIntersection(RoleType[] roles1, RoleType[] roles2) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < roles1.length) {
            int j = 0;
            while (!ret && j < roles2.length) {
                if (roles2[j].getName().equals(roles1[i].getName())) {
                    ret = true;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    protected static boolean isGlobalizedTrigger(ValidationResult result) {
        boolean ret = false;
        XPath xpath = result.getXPathExpression();
        if (xpath != null && xpath.getExpression() instanceof FuncExtFunction && ((FuncExtFunction)xpath.getExpression()).getFunctionName().equals("globalizedTrigger")) {
            ret = true;
        }
        return ret;
    }

    protected static String extractGTSubExpressions(ValidationResult result, RoleType[] roleTypes) {
        String ret = null;
        StringBuffer buf = new StringBuffer();
        XPath xpath = result.getXPathExpression();
        String includedExpr = null;
        int includeCount = 0;
        if (xpath != null && xpath.getExpression() instanceof FuncExtFunction && ((FuncExtFunction)xpath.getExpression()).getFunctionName().equals("globalizedTrigger")) {
            FuncExtFunction func = (FuncExtFunction)xpath.getExpression();
            int i = 0;
            while (i < func.getArgCount()) {
                String expr = func.getArg(i).toString();
                String role = func.getArg(i + 1).toString();
                boolean include = false;
                int j = 0;
                while (!include && j < roleTypes.length) {
                    if (roleTypes[j].getName().equals(role)) {
                        include = true;
                    }
                    ++j;
                }
                if (include) {
                    includedExpr = expr;
                    ++includeCount;
                    if (i > 0) {
                        buf.append(COMMA);
                    }
                    buf.append(DOUBLE_QUOTE_MARK);
                    buf.append(expr);
                    buf.append(DOUBLE_QUOTE_MARK);
                    buf.append(COMMA);
                    buf.append(SINGLE_QUOTE_MARK);
                    buf.append(role);
                    buf.append(SINGLE_QUOTE_MARK);
                }
                i += 2;
            }
        }
        if (includeCount == 1) {
            ret = includedExpr;
        } else {
            buf.insert(0, GLOBALIZED_TRIGGER_START);
            buf.append(GLOBALIZED_TRIGGER_END);
            ret = buf.toString();
        }
        return ret;
    }

    static class ErrorRecorder
    implements ModelListener {
        private int m_errorCount = 0;

        ErrorRecorder() {
        }

        public void report(Object src, String mesg, int type) {
            this.report(src, mesg, type, null);
        }

        public void report(Object src, String mesg, int type, Properties props) {
            if (type == 2) {
                ++this.m_errorCount;
            }
        }

        public int getErrorCount() {
            return this.m_errorCount;
        }
    }
}

