/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.xpath;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.xpath.functions.XPathFunction;

public class XPathFunctionRegistry {
    private static Hashtable m_functions = new Hashtable();
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.xpath");
    private static final String FUNCTION_SUFFIX = "Function";

    public static XPathFunction getFunction(String name) {
        XPathFunction ret = null;
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (m_functions.containsKey(name)) {
            ret = (XPathFunction)m_functions.get(name);
        } else {
            String className = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            className = String.valueOf(XPathFunction.class.getPackage().getName()) + "." + className + FUNCTION_SUFFIX;
            try {
                Class<?> cls = Class.forName(className);
                ret = (XPathFunction)cls.newInstance();
                if (ret != null) {
                    m_functions.put(ret.getName(), ret);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to find function '" + name + "'", e);
            }
        }
        return ret;
    }

    public static XPathFunction[] getFunctions() {
        XPathFunction[] ret = new XPathFunction[m_functions.size()];
        Enumeration iter = m_functions.keys();
        int index = 0;
        while (iter.hasMoreElements()) {
            ret[index++] = (XPathFunction)iter.nextElement();
        }
        return ret;
    }
}

