/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.Assign;
import org.pi4soa.cdl.BindDetails;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Conditional;
import org.pi4soa.cdl.CopyDetails;
import org.pi4soa.cdl.DefaultCDLVisitor;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Finalize;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.When;
import org.pi4soa.cdl.While;
import org.pi4soa.common.util.NamesUtil;

public class VariableUtil {
    public static boolean isExchangeVariable(Variable var) {
        boolean ret = false;
        if (var != null && var.getEnclosingChoreography() != null) {
            ExchangeVariableVisitor evv = new ExchangeVariableVisitor(var);
            var.getEnclosingChoreography().visit(evv);
            ret = evv.isExchangeVariable();
        }
        return ret;
    }

    public static boolean isVariableUsed(Variable var, ParticipantType partType) {
        return VariableUtil.isVariableUsed(var, partType, new Vector());
    }

    protected static boolean isVariableUsed(Variable var, ParticipantType partType, List varList) {
        boolean ret = false;
        if (var != null && !varList.contains(var)) {
            varList.add(var);
            VariableUsageVisitor visitor = new VariableUsageVisitor(var, partType, varList);
            Choreography choreo = var.getEnclosingChoreography();
            int i = 0;
            while (!visitor.isVariableUsed() && i < choreo.getActivities().size()) {
                Activity act = (Activity)choreo.getActivities().get(i);
                act.visit(visitor);
                ++i;
            }
            i = 0;
            while (!visitor.isVariableUsed() && i < choreo.getFinalizers().size()) {
                FinalizerHandler fh = (FinalizerHandler)choreo.getFinalizers().get(i);
                fh.visit(visitor);
                ++i;
            }
            if (!visitor.isVariableUsed() && choreo.getExceptionHandler() != null) {
                choreo.getExceptionHandler().visit(visitor);
            }
            ret = visitor.isVariableUsed();
        }
        return ret;
    }

    static class ExchangeVariableVisitor
    extends DefaultCDLVisitor {
        private Variable m_variable = null;
        private boolean m_exchangeVariable = false;

        public ExchangeVariableVisitor(Variable var) {
            this.m_variable = var;
        }

        public void interaction(Interaction interaction) {
            Iterator iter = interaction.getExchangeDetails().iterator();
            while (!this.isExchangeVariable() && iter.hasNext()) {
                ExchangeDetails exchange = (ExchangeDetails)iter.next();
                if (exchange.getSendVariable() == this.m_variable) {
                    this.m_exchangeVariable = true;
                }
                if (exchange.getReceiveVariable() != this.m_variable) continue;
                this.m_exchangeVariable = true;
            }
        }

        public void perform(Perform perform) {
            if (!this.isExchangeVariable()) {
                Iterator iter = perform.getBindDetails().iterator();
                while (!this.isExchangeVariable() && iter.hasNext()) {
                    BindDetails bind = (BindDetails)iter.next();
                    if (bind.getThisVariable() != this.m_variable) continue;
                    this.m_exchangeVariable = VariableUtil.isExchangeVariable(bind.getFreeVariable());
                }
            }
        }

        public boolean isExchangeVariable() {
            return this.m_exchangeVariable;
        }
    }

    static class VariableUsageVisitor
    extends DefaultCDLVisitor {
        private Variable m_variable = null;
        private List m_varList = null;
        private boolean m_used = false;
        private RoleType[] m_roleTypes = null;
        private ParticipantType m_participantType = null;

        public VariableUsageVisitor(Variable var, ParticipantType partType, List varList) {
            this.m_variable = var;
            this.m_participantType = partType;
            this.m_varList = varList;
            if (partType != null) {
                EList<RoleType> roleTypes = partType.getRoleTypes();
                this.m_roleTypes = new RoleType[roleTypes.size()];
                roleTypes.toArray((RoleType[])this.m_roleTypes);
            }
        }

        public boolean isVariableUsed() {
            return this.m_used;
        }

        public void assign(Assign assign) {
            if (this.isRelevant(assign)) {
                for (CopyDetails copy : assign.getCopyDetails()) {
                    if (copy.getSourceVariable() == this.m_variable) {
                        this.m_used = true;
                    } else if (copy.getSourceExpression() != null) {
                        this.checkExpression(copy.getSourceExpression());
                    }
                    if (copy.getTargetVariable() != this.m_variable) continue;
                    this.m_used = true;
                }
            }
        }

        public void conditionalStart(Conditional conditional) {
            if (this.isRelevant(conditional)) {
                this.checkExpression(conditional.getExpression());
            }
        }

        public void finalize(Finalize finalize) {
            if (this.isRelevant(finalize)) {
                this.checkExpression(finalize.getChoreographyInstanceId());
            }
        }

        public void perform(Perform perform) {
            if (this.isRelevant(perform)) {
                this.checkExpression(perform.getChoreographyInstanceId());
                Iterator iter = perform.getBindDetails().iterator();
                while (!this.isVariableUsed() && iter.hasNext()) {
                    BindDetails bind = (BindDetails)iter.next();
                    if (!this.isRelevant(bind) || bind.getThisVariable() != this.m_variable || !VariableUtil.isVariableUsed(bind.getFreeVariable(), this.m_participantType, this.m_varList)) continue;
                    this.m_used = true;
                }
            }
        }

        public void interaction(Interaction interaction) {
            if (this.isRelevant(interaction)) {
                CDLType detail;
                if (interaction.getChannelVariable() == this.m_variable) {
                    this.m_used = true;
                }
                Iterator iter = interaction.getExchangeDetails().iterator();
                while (iter.hasNext() && !this.isVariableUsed()) {
                    detail = (ExchangeDetails)iter.next();
                    if (detail.getSendVariable() == this.m_variable) {
                        this.m_used = true;
                    }
                    if (detail.getReceiveVariable() != this.m_variable) continue;
                    this.m_used = true;
                }
                iter = interaction.getRecordDetails().iterator();
                while (iter.hasNext() && !this.isVariableUsed()) {
                    detail = (RecordDetails)iter.next();
                    if (detail.getSourceVariable() == this.m_variable) {
                        this.m_used = true;
                    }
                    if (detail.getTargetVariable() == this.m_variable) {
                        this.m_used = true;
                    }
                    if (this.isVariableUsed() || !NamesUtil.isSet((String)detail.getSourceExpression())) continue;
                    this.checkExpression(detail.getSourceExpression());
                }
            }
        }

        public void whenStart(When when) {
            if (this.isRelevant(when)) {
                this.checkExpression(when.getExpression());
            }
        }

        public void whileStart(While whileElem) {
            if (this.isRelevant(whileElem)) {
                this.checkExpression(whileElem.getExpression());
            }
        }

        protected void checkExpression(String expr) {
            if (NamesUtil.isSet((String)expr) && expr.indexOf(this.m_variable.getName()) != -1) {
                this.m_used = true;
            }
        }

        protected boolean isRelevant(CDLType cdlType) {
            boolean ret = false;
            if (this.m_roleTypes != null) {
                if (cdlType.isRelevantToRoleTypes(this.m_roleTypes)) {
                    ret = true;
                }
            } else {
                ret = true;
            }
            return ret;
        }
    }
}

