/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;

public class PackageUtil {
    public static ParticipantType getParticipantForRoleType(RoleType roleType) {
        ParticipantType ret = null;
        Package pack = roleType.getPackage();
        if (pack != null && pack.getTypeDefinitions() != null) {
            Iterator iter = pack.getTypeDefinitions().getParticipantTypes().iterator();
            while (ret == null && iter.hasNext()) {
                ParticipantType ptype = (ParticipantType)iter.next();
                if (!ptype.getRoleTypes().contains((Object)roleType)) continue;
                ret = ptype;
            }
        }
        return ret;
    }

    public static List getParticipantTypesForRoleType(RoleType roleType) {
        Vector<ParticipantType> ret = new Vector<ParticipantType>();
        Package pack = roleType.getPackage();
        if (pack != null && pack.getTypeDefinitions() != null) {
            for (ParticipantType ptype : pack.getTypeDefinitions().getParticipantTypes()) {
                if (!ptype.getRoleTypes().contains((Object)roleType)) continue;
                ret.add(ptype);
            }
        }
        return ret;
    }

    public static List getParticipantsForRoleTypes(Package cdlpack, List roleTypes) {
        Vector<ParticipantType> ret = new Vector<ParticipantType>();
        if (cdlpack != null && cdlpack.getTypeDefinitions() != null) {
            for (ParticipantType ptype : cdlpack.getTypeDefinitions().getParticipantTypes()) {
                if (!ptype.getRoleTypes().containsAll((Collection)roleTypes)) continue;
                ret.add(ptype);
            }
        }
        return ret;
    }

    public static Collection getRelevantBehaviors(RoleType roleType, Collection col) {
        Vector<Behavior> ret = new Vector<Behavior>();
        for (Behavior behavior : col) {
            if (behavior != null && roleType != behavior.getParent()) continue;
            ret.add(behavior);
        }
        return ret;
    }
}

