/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces.impl;

import java.util.Iterator;
import java.util.List;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.interfaces.DefaultRoleTypeDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDeriver;
import org.pi4soa.cdl.interfaces.InterfaceException;
import org.pi4soa.cdl.interfaces.InterfaceVisitor;
import org.pi4soa.cdl.interfaces.RoleTypeDefinition;
import org.pi4soa.cdl.interfaces.impl.CDLInterfaceBuilder;

public class InterfaceDeriverImpl
implements InterfaceDeriver {
    public void visitInterfaces(Package cdlpack, InterfaceVisitor visitor) throws InterfaceException {
        List roleTypes = this.buildRoleTypeInterfaces(cdlpack);
        if (roleTypes != null) {
            for (DefaultRoleTypeDefinition rtdef : roleTypes) {
                rtdef.visit(visitor);
            }
        }
    }

    protected List buildRoleTypeInterfaces(Package cdlpack) throws InterfaceException {
        List ret = null;
        CDLInterfaceBuilder builder = new CDLInterfaceBuilder();
        builder.build(cdlpack);
        ret = builder.getRoleTypeDefinitions();
        return ret;
    }

    public RoleTypeDefinition getRoleTypeDefinition(RoleType roleType) throws InterfaceException {
        List roleTypes;
        DefaultRoleTypeDefinition ret = null;
        if (roleType != null && roleType.getPackage() != null && (roleTypes = this.buildRoleTypeInterfaces(roleType.getPackage())) != null) {
            Iterator iter = roleTypes.iterator();
            while (ret == null && iter.hasNext()) {
                DefaultRoleTypeDefinition rtdef = (DefaultRoleTypeDefinition)iter.next();
                if (!rtdef.getRoleType().equals(roleType.getName())) continue;
                ret = rtdef;
            }
        }
        return ret;
    }

    public RoleTypeDefinition[] getRoleTypeDefinitions(Package cdlpack) throws InterfaceException {
        List roleTypes;
        RoleTypeDefinition[] ret = null;
        if (cdlpack != null && (roleTypes = this.buildRoleTypeInterfaces(cdlpack)) != null) {
            ret = new RoleTypeDefinition[roleTypes.size()];
            int i = 0;
            while (i < roleTypes.size()) {
                ret[i] = (RoleTypeDefinition)roleTypes.get(i);
                ++i;
            }
        }
        return ret;
    }
}

