/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.interfaces.DefaultInterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceVisitor;
import org.pi4soa.cdl.interfaces.RoleTypeDefinition;

public class DefaultRoleTypeDefinition
implements RoleTypeDefinition {
    private String m_participantType = null;
    private String m_namespace = null;
    private String m_roleType = null;
    private List m_interfaces = new Vector();

    public DefaultRoleTypeDefinition(String namespace, String participantType, String roleType) {
        this.m_namespace = namespace;
        this.m_participantType = participantType;
        this.m_roleType = roleType;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getParticipantType() {
        return this.m_participantType;
    }

    public String getRoleType() {
        return this.m_roleType;
    }

    public List getInterfaces() {
        return this.m_interfaces;
    }

    public InterfaceDefinition getInterfaceForBehavior(String behaviorName) {
        InterfaceDefinition ret = null;
        if (behaviorName == null && this.getInterfaces().size() == 1) {
            ret = (InterfaceDefinition)this.getInterfaces().get(0);
        } else {
            Iterator iter = this.getInterfaces().iterator();
            while (ret == null && iter.hasNext()) {
                ret = (DefaultInterfaceDefinition)iter.next();
                if (ret.getBehaviorName().equals(behaviorName)) continue;
                ret = null;
            }
        }
        return ret;
    }

    public InterfaceDefinition getInterface(String namespace, String name) {
        DefaultInterfaceDefinition ret = null;
        if (namespace != null && name != null) {
            Iterator iter = this.getInterfaces().iterator();
            while (ret == null && iter.hasNext()) {
                ret = (DefaultInterfaceDefinition)iter.next();
                if (ret.getNamespace().equals(namespace) && ret.getInterfaceName() != null && ret.getInterfaceName().equals(name)) continue;
                ret = null;
            }
        }
        return ret;
    }

    public void visit(InterfaceVisitor visitor) {
        visitor.roleTypeStart(this);
        for (DefaultInterfaceDefinition idef : this.getInterfaces()) {
            idef.visit(visitor);
        }
        visitor.roleTypeEnd(this);
    }

    public int hashCode() {
        return this.getRoleType().hashCode();
    }

    public boolean equals(Object obj) {
        DefaultRoleTypeDefinition rtdef;
        boolean ret = false;
        if (obj instanceof DefaultRoleTypeDefinition && (rtdef = (DefaultRoleTypeDefinition)obj).getParticipantType().equals(this.getParticipantType()) && rtdef.getNamespace().equals(this.getNamespace()) && rtdef.getRoleType().equals(this.getRoleType())) {
            ret = true;
        }
        return ret;
    }
}

