/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceVisitor;
import org.pi4soa.cdl.interfaces.MessageDefinition;
import org.pi4soa.cdl.interfaces.OperationDefinition;
import org.pi4soa.common.util.NamesUtil;

public class DefaultOperationDefinition
implements OperationDefinition {
    private String m_operationName = null;
    private List m_messages = new Vector();
    private InterfaceDefinition m_interfaceDefinition = null;

    public DefaultOperationDefinition(String name) {
        this.m_operationName = name;
    }

    public DefaultOperationDefinition(InterfaceDefinition idef, String name) {
        this.m_interfaceDefinition = idef;
        this.m_operationName = name;
    }

    public String getOperationName() {
        return this.m_operationName;
    }

    public int getOperationType() {
        int ret = -1;
        boolean f_request = false;
        boolean f_response = false;
        int i = 0;
        while (i < this.getMessages().size()) {
            MessageDefinition md = (MessageDefinition)this.getMessages().get(i);
            if (md.getClassification() == 0 || md.getClassification() == 2) {
                f_request = true;
            } else {
                f_response = true;
            }
            ++i;
        }
        if (f_request) {
            ret = f_response ? 1 : 0;
        } else if (f_response) {
            ret = 2;
        }
        return ret;
    }

    public List getMessages() {
        return this.m_messages;
    }

    public List getMessages(int mesgType) {
        Vector<MessageDefinition> ret = new Vector<MessageDefinition>();
        for (MessageDefinition mdef : this.m_messages) {
            if (mdef.getClassification() != mesgType) continue;
            ret.add(mdef);
        }
        return ret;
    }

    public MessageDefinition getMessage(String faultNamespace, String faultName, int mesgType) {
        MessageDefinition ret = null;
        Iterator iter = this.getMessages().iterator();
        while (ret == null && iter.hasNext()) {
            MessageDefinition md = (MessageDefinition)iter.next();
            if (md.getClassification() != mesgType) continue;
            if (mesgType == 2 || mesgType == 3) {
                if (!md.getFaultName().equals(faultName) || (!NamesUtil.isSet((String)md.getFaultNamespace()) || !NamesUtil.isSet((String)faultNamespace) || !md.getFaultNamespace().equals(faultNamespace)) && (NamesUtil.isSet((String)md.getFaultNamespace()) || NamesUtil.isSet((String)faultNamespace))) continue;
                ret = md;
                continue;
            }
            ret = md;
        }
        return ret;
    }

    public InterfaceDefinition getInterfaceDefinition() {
        return this.m_interfaceDefinition;
    }

    public void visit(InterfaceVisitor visitor) {
        visitor.operationStart(this);
        for (MessageDefinition mdef : this.getMessages()) {
            mdef.visit(visitor);
        }
        visitor.operationEnd(this);
    }

    public int hashCode() {
        return this.getOperationName().hashCode();
    }

    public boolean equals(Object obj) {
        DefaultOperationDefinition opdef;
        boolean ret = false;
        if (obj instanceof DefaultOperationDefinition && (opdef = (DefaultOperationDefinition)obj).getOperationName().equals(this.getOperationName())) {
            ret = true;
        }
        return ret;
    }
}

